/* fastll.h - speed oriented doubly linked list
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/

#ifndef FAST_LIST_H
#include "../fastmem/fastmem.h"

#ifndef NULL
#define NULL 0L;
#endif

typedef struct fast_ll_node{
	void *data;
	struct fast_ll_node *prev;
	struct fast_ll_node *next;
}fast_ll_node;

typedef struct{
	fast_mem *list_storage;
	int num_items;
	int max_items;

	fast_ll_node *head;
	fast_ll_node *tail;
	fast_ll_node *current;
}fast_ll;

/****************************** prototypes **********************************/
/* set up the fast linked list */
fast_ll *fastll_init(int max_items);

/* clear the fast linked list leaving it as though just initialised*/
void fastll_clear(fast_ll *list);

/* destroy the fast linked list and the storage it uses */
fast_ll *fastll_destroy(fast_ll *list);

/* add an item to the end of the list */
void fastll_add_to_end(fast_ll *list,void *list_item);

/* add an item to the start of the list */
void fastll_add_to_start(fast_ll *list,void *list_item);

/* add an item after the current item in the list */
void fastll_add_after_current(fast_ll *list,void *list_item);

/* add an item before the current item in the list */
void fastll_add_before_current(fast_ll *list,void *list_item);

/* remove the current item in the list */
void fastll_remove_current(fast_ll *list);

/* remove the head of the list */
void fastll_remove_head(fast_ll *list);

/* remove the tail of the list */
void fastll_remove_tail(fast_ll *list);

/* get the number of free blocks */
#define fastll_get_free_blocks(l) ((l)->max_items - (l)->num_items)

/* get the number of items */
#define fastll_get_used_blocks(l) ((l)->num_items)

/* get a pointer to the data at a given node */
#define fastll_get_data_pointer(node) ((node)->data)

/* move the current pointer to the next item in the list if it exists */
#define fastll_move_current_forward(l) if((l)->current->next!=NULL)(l)->current=(l)->current->next

/* move the current pointer to the previous item in the list if it exists */
#define fastll_move_current_backward(l) if((l)->current->prev!=NULL)(l)->current=(l)->current->prev

/* is the current item the last in the list? */
#define fastll_current_at_end(l) ((l)->current==(l)->tail)

/* is the current item the first in the list? */
#define fastll_current_at_start(l) ((l)->current==(l)->head)

/* is the current item NULL? */
#define fastll_current_is_null(l) ((l)->current==NULL)

/* set the current item to the first in the list */
#define fastll_set_current_to_start(l) ((l)->current=(l)->head)

/* set the current item to the last in the list */
#define fastll_set_current_to_end(l) ((l)->current=(l)->tail)

/* set the current item to NULL */
#define fastll_set_current_to_null(l) ((l)->current=NULL)

#define FAST_LIST_H  1
#endif /* file */

