/* demo5.c
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <jlib.h>

#define NUM_SPRITES 32
#define NUM_ITERATIONS 500

#define RANDOM(u) ( rand() % ( ((u) + 1)  ) )

int main(void)
{
 int i;
 unsigned char *pal;
 sprite_system *demo_sprites;
 buffer_rec *offscreen;
 USHORT animation[6] = {0,1,2,3,4,5};
 
 /* init stuff*/
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 demo_sprites = sprite_init(NUM_SPRITES,64);
 pal = screen_load_pal("demo5.pal");
 sprite_load("demo5.spr",demo_sprites);
  
 screen_set_video_mode();

 srand(time(NULL));

 screen_block_set_pal(pal);

 /* set up sprite movements */
 for(i=0;i<NUM_SPRITES;i++){
     sprite_set_xy(demo_sprites,i,RANDOM(B_X_SIZE(offscreen))+SPR_MAX_X,
				  RANDOM(B_Y_SIZE(offscreen))+SPR_MAX_Y);
     sprite_set_an_frame(demo_sprites,i,RANDOM(5));
     sprite_set_move_info(demo_sprites,i,RANDOM(2)+1,-(RANDOM(4)),-(RANDOM(4)));
     sprite_set_anim_info(demo_sprites,i,RANDOM(3)+1,6,animation);
     sprite_turn_on(demo_sprites,i);
 }

 fgetc(stdin);

 for(i=0;i<NUM_ITERATIONS;i++){
   buff_save_all_sprites(demo_sprites,offscreen);

   buff_draw_all_sprites(demo_sprites,offscreen);

   screen_blit_fs_buffer(offscreen);

   buff_rest_all_sprites(demo_sprites,offscreen);

   sprite_update_all_anim_and_move(demo_sprites);
 };

 screen_restore_video_mode();
 
 return(1);
}
