;****************************************
;* ASM example to use FLamoot VGA SetUp *
;****************************************

.MODEL SMALL

.STACK 256

.DATA

 INCLUDE VIDEO.INC

Table dw m360x480x256p,m160x100x256c,m720x480x16p,m320x200x16c,m256x256x256c
      dw m1440x480x4c,m720x480x16c
TLen  EQU ($-(OFFSET Table))/2

.CODE
.386

.STARTUP

 mov   si,OFFSET Table
 mov   cx,TLen

Looper: 
 push  cx

 REPT  10          ; wait VRT
 VSYNC
 ENDM

 lodsw
 push  ax          ; push mode no ... 

 call _SetVGA
 add   sp,2        ; becoze of C call ...

 mov   ax,0a000h
 mov   es,ax
 xor   di,di
 xor   eax,eax
 mov   cx,65536/4
@@:
 stosd
 add   eax,01010101h 
 dec   cx
 jnz   @B

@@:
 in    al,60h      ; wait until keypressed
 cmp   al,39h
 jnz   @B

 mov   ax,40h      ; flush keyboard buffer
 mov   es,ax
 mov   ax,es:[001ah]
 mov   es:[001ch],ax

 pop   cx
 dec   cx
 jnz   Looper

 mov   ax,3        ; back to text mode 
 int   10h

.EXIT

 END
