/*

        An example of having more than one LFS open at any one time.

*/

#include <stdlib.h>
#include <stdio.h>
#include "..\include\ilfs.h"

void main(void)
{
        ILFS_LIB *lib_1;
        ILFS_LIB *lib_2;

        ilfs(ilfs_show_banner);

        /* open TEST.LFS and store it in  lib_1  */
        ilfs(ilfs_open_lib, "test.lfs");
        ilfs(ilfs_get_lib, lib_1);

        /* You only need to worry about using the ilfs_get and ilfs_set
           commands if you are going to use more than one LFS at the same
           time.  Most people will only ever use one at any give time
        */

        /* open TEST-2.LFS and store it in  lib_2  */
        ilfs(ilfs_open_lib, "test-2.lfs");
        ilfs(ilfs_get_lib, lib_2);

        /* Set current lib to lib_2 */
        ilfs(ilfs_set_lib, lib_2);
        ilfs(ilfs_close_lib);

        /* Set current lib to lib_1 */
        ilfs(ilfs_set_lib, lib_1);
        ilfs(ilfs_close_lib);

        /* uninstall */
        ilfs(ilfs_uninstall);
}