;----------------------------------------------------
;routines for equalizers and trace in hsctrack.
;----------------------------------------------------

;---------------------------------------
;installs user-charset (ASCII 0-2)
;---------------------------------------

InstallChar     PROC

                pusha
                push es

                mov  ax,1110h                   ;load chars with BIOS
                mov  bx,0800h                   ;(who cares about speed)
                mov  cx,0003h
                mov  dx,0000h
                push cs
                pop  es
                mov  bp,OFFSET xxCharSet
                int  10h

                pop  es
                popa
                ret

xxCharSet:                                      ;definition of the characters
                db 00000000b
                db 00000000b
                db 00000000b
                db 00000000b
                db 00000000b
                db 00000000b
                db 00000000b
                db 00000000b

                db 00000000b
                db 11100000b
                db 11100000b
                db 11100000b
                db 11100000b
                db 11100000b
                db 00000000b
                db 00000000b

                db 00000000b
                db 11101110b
                db 11101110b
                db 11101110b
                db 11101110b
                db 11101110b
                db 00000000b
                db 00000000b

InstallChar     ENDP

;---------------------------------------
;link equalizer routines into music irq
;---------------------------------------

StartEqual      PROC

                pusha
                push ds

                mov  ah,6                       ;_HscPlayer function 6, bl=1
                mov  bl,1                       ; -> install user irq
                mov  dx,OFFSET Equalizer
                push cs
                pop  ds
                call far ptr _HscPlayer
                call ClearEqual

                pop  ds
                popa
                ret

StartEqual      ENDP

;---------------------------------------
;take equalizer out of the  irq
;---------------------------------------

StopEqual       PROC

                pusha

                mov  ah,6                       ;_HscPlayer funtion 6, bl=0
                mov  bl,0                       ; -> remove user irq
                call far ptr _HscPlayer
                call ClearEqual                 ;and delete screen

                popa
                ret

StopEqual       ENDP

;---------------------------------------
;clear equalizer area
;---------------------------------------

ClearEqual      PROC

                pusha                           ;blah, blah, nothing important
                push es

                mov  di,VRAM
                mov  es,di

                mov  si,00h

xx_equ_loop:    mov  di,cs:xx_equ_base+si
                mov  ax,1200h
                stosw
                stosw
                stosw

                add  di,2
                mov  ax,1300h
                stosw
                stosw

                add  di,2
                mov  cx,08h
                mov  ax,1a00h
                rep  stosw

                add  si,2
                cmp  si,18
                jne  xx_equ_loop

                mov  di,14ach
                mov  ax,1e20h
                mov  es:di,ax
                mov  es:di+2,ax
                mov  es:di+10,ax
                mov  es:di+12,ax
                mov  es:di+20,ax
                mov  es:di+22,ax

                pop  es
                popa
                ret

xx_equ_base     dw   0e66h,0f06h,0fa6h
                dw   1046h,10e6h,1186h
                dw   1226h,12c6h,1366h

ClearEqual      ENDP

;---------------------------------------
;the real equalizer routines
;---------------------------------------

Equalizer       PROC

                pusha
                push ds
                push es

                push cs
                pop  es
                mov  si,OFFSET xx_hsc_note
                mov  ah,07h                     ;_HscPlayer function 7
                call far ptr _HscPlayer         ; -> get player state

                mov  si,VRAM
                mov  es,si

                push cs
                pop  ds
                mov  cx,00h

xx_equ_loop:    mov  si,cx                      ;put equalizer values to bars
                add  si,OFFSET xx_hsc_equalizer
                mov  bl,ds:si
                inc  bl
                and  bx,1fh
                shl  bx,4
                add  bx,OFFSET xx_equ_string

                mov  si,cx
                shl  si,1
                mov  di,cs:xx_equ_base+si
                mov  dl,02h

                cmp  es:di,dl
                ja   xx_equ_j1
                mov  ax,cs:bx
                mov  es:di,ax

xx_equ_j1:      cmp  es:di+2,dl                 ;ignore this check
                ja   xx_equ_j2                  ;it's a dirty way for clipping
                mov  ax,cs:bx+2                 ;windows
                mov  es:di+2,ax

xx_equ_j2:      cmp  es:di+4,dl
                ja   xx_equ_j3
                mov  ax,cs:bx+4
                mov  es:di+4,ax

xx_equ_j3:      cmp  es:di+6,dl
                ja   xx_equ_j4
                mov  ax,cs:bx+6
                mov  es:di+6,ax

xx_equ_j4:      cmp  es:di+8,dl
                ja   xx_equ_j5
                mov  ax,cs:bx+8
                mov  es:di+8,ax

xx_equ_j5:      cmp  es:di+10,dl
                ja   xx_equ_j6
                mov  ax,cs:bx+10
                mov  es:di+10,ax

xx_equ_j6:      cmp  es:di+12,dl
                ja   xx_equ_j7
                mov  ax,cs:bx+12
                mov  es:di+12,ax

xx_equ_j7:      cmp  es:di+14,dl
                ja   xx_equ_j8
                mov  ax,cs:bx+14
                mov  es:di+14,ax

xx_equ_j8:      mov  si,cx                      ;flash note on equalizer peaks
                add  si,OFFSET xx_hsc_playing
                mov  ax,1312h
                cmp  ds:si,BYTE PTR 0ffh
                jne  xx_equ_j9
                mov  ax,1b1ah
xx_equ_j9:      mov  bx,cx
                shl  bx,1
                mov  di,cs:xx_equ_base+bx
                sub  di,0dh
                mov  es:di,al
                mov  es:di+2,al
                mov  es:di+4,al
                mov  es:di+8,ah
                mov  es:di+10,ah
                mov  ds:si,BYTE PTR 00h

                mov  si,cx                      ;put actual note to screen
                add  si,OFFSET xx_hsc_note
                mov  al,ds:si
                sub  al,1
                jc   xx_equ_no_note
                xor  ah,ah
                mov  bl,12
                div  bl
                mov  dl,al
                mov  al,ah
                mov  bl,3
                mul  bl                 ;note*3 = offset string in cs:Noten
                mov  si,ax
                add  si,offset cs:Noten

                mov  bx,cx
                shl  bx,1
                mov  ax,cs:xx_instr_pos+bx
                sub  ax,0400h

                push ds
                push cs
                pop  ds
                call PutString
                pop  ds

                push es
                mov  bx,cx
                shl  bx,1
                mov  di,cs:xx_equ_base+bx
                sub  di,10
                add  dl,49
                mov  ax,VRAM
                mov  es,ax
                mov  BYTE PTR es:[di],dl
                pop  es

xx_equ_no_note: mov  si,cx                      ;put actual instrument to screen
                add  si,OFFSET xx_hsc_instr
                mov  bl,ds:si
                mov  di,cx
                shl  di,1
                mov  ax,cs:xx_instr_pos+di
                call PrintByte

                inc  cx
                cmp  cx,09h
                je   xx_equ_no_loop
                jmp  xx_equ_loop

xx_equ_no_loop: mov  si,OFFSET xx_hsc_pattern   ;and actual pattern
                mov  bl,ds:si
                mov  ax,0621h
                call PrintByte
                cmp  cs:HelpAktiv,BYTE PTR 00h
                jne  xx_equ_no_flw
                mov  si,OFFSET xx_hsc_track     ;and track
                mov  bl,ds:si
                add  ah,5
                call PrintByte
                mov  si,OFFSET xx_hsc_position  ;and position
                mov  bl,ds:si
                add  ah,5
                call PrintByte
                cmp  cs:TLine,bl
                je   xx_equ_no_flw

                cmp  cs:FollowPlay,BYTE PTR 00h ;and here the trace, who cares
                je   xx_equ_no_flw
                mov  si,OFFSET xx_hsc_track
                mov  bl,ds:si
                mov  cs:Track,bl
                mov  si,OFFSET xx_hsc_position
                mov  bl,ds:si
                mov  cs:TLine,bl
                call PutTrackLine
                mov  si,OFFSET xx_hsc_pattern
                mov  bl,ds:si
                mov  cs:PattLine,bl
                call PutPTable
                
xx_equ_no_flw:  pop  es
                pop  ds
                popa
                retf

xx_instr_pos    dw   0717h,0718h,0719h          ;the string offsets on screen
                dw   071ah,071bh,071ch
                dw   071dh,071eh,071fh

xx_equ_base     dw   0e74h,0f14h,0fb4h
                dw   1054h,10f4h,1194h
                dw   1234h,12d4h,1374h

                ;the equalizer bars .. i was so lazy and this looks so lame

xx_equ_string   db   0,1ah,0,1ah,0,1ah,0,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;0
                db   1,1ah,0,1ah,0,1ah,0,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;1
                db   2,1ah,0,1ah,0,1ah,0,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;2
                db   2,1ah,1,1ah,0,1ah,0,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;3
                db   2,1ah,2,1ah,0,1ah,0,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;4
                db   2,1ah,2,1ah,1,1ah,0,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;5
                db   2,1ah,2,1ah,2,1ah,0,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;6
                db   2,1ah,2,1ah,2,1ah,1,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;7
                db   2,1ah,2,1ah,2,1ah,2,1ah,0,1ah,0,1eh,0,1eh,0,1ch ;8
                db   2,1ah,2,1ah,2,1ah,2,1ah,1,1ah,0,1eh,0,1eh,0,1ch ;9
                db   2,1ah,2,1ah,2,1ah,2,1ah,2,1ah,0,1eh,0,1eh,0,1ch ;a
                db   2,1ah,2,1ah,2,1ah,2,1ah,2,1ah,1,1eh,0,1eh,0,1ch ;b
                db   2,1ah,2,1ah,2,1ah,2,1ah,2,1ah,2,1eh,0,1eh,0,1ch ;c
                db   2,1ah,2,1ah,2,1ah,2,1ah,2,1ah,2,1eh,1,1eh,0,1ch ;d
                db   2,1ah,2,1ah,2,1ah,2,1ah,2,1ah,2,1eh,2,1eh,0,1ch ;e
                db   2,1ah,2,1ah,2,1ah,2,1ah,2,1ah,2,1eh,2,1eh,1,1ch ;f
                db   2,1ah,2,1ah,2,1ah,2,1ah,2,1ah,2,1eh,2,1eh,2,1ch ;10

xx_hsc_note      db  9 dup (0)  ;the array for the function 07h
xx_hsc_instr     db  9 dup (0)
xx_hsc_equalizer db  9 dup (0)
xx_hsc_playing   db  9 dup (0)
xx_hsc_pattern   db  0
xx_hsc_track     db  0
xx_hsc_position  db  0
xx_hsc_on_off    db  0

Equalizer       ENDP
