/* Soundblaster Digital Audio library for Borland C++. *
 *                    											 *
 * Note: All variables defined in this header are      *
 * read only. Don't change unless you know what you	 *
 * are doing!                                          */

/* Structure definitions */

struct dsp_device_caps
{
	unsigned min_speed;

	unsigned max_8bit;
	unsigned max_8bit_s;

	unsigned max_16bit;
	unsigned max_16bit_s;

	unsigned	max_8bit_rec;
	unsigned max_8bit_rec_s;

	unsigned	max_16bit_rec;
	unsigned max_16bit_rec_s;

	char		supports_signed;
};


/* Port offsets from base address */

#define MixAddrOffset		0x04
#define MixDataOffset		0x05

#define FMAddrOffset			0x08
#define FMDataOffset			0x09
#define FMStatOffset			0x08

#define DSPResetOffset		0x06
#define DSPReadOffset		0x0A
#define DSPWriteOffset		0x0C
#define DSPRStatOffset		0x0E
#define DSPIrqAck8Offset	0x0E
#define DSPIrqAck16Offset	0x0F

/* Macros for port addresses */

#define MixAddrPort			(SBport+MixAddrOffset)
#define MixDataPort			(SBport+MixDataOffset)

#define FMAddrPort   		(SBport+FMAddrOffset)
#define FMDataPort			(SBport+FMDataOffset)
#define FMStatPort			(SBport+FMStatOffset)

#define DSPResetPort			(SBport+DSPResetOffset)
#define DSPReadPort  		(SBport+DSPReadOffset)
#define DSPWritePort			(SBport+DSPWriteOffset)
#define DSPRStatPort			(SBport+DSPRStatOffset)
#define DSPIrqAck8Port		(SBport+DSPIrqAck8Offset)
#define DSPIrqAck16Port		(SBport+DSPIrqAck16Offset)

/* Mixer source values for high-level mixer control */

#define MIXmaster 			0
#define MIXvoice				1
#define MIXfm					2
#define MIXline				3
#define MIXcd					4
#define MIXgain				5
#define MIXtreble				6
#define MIXbass				7

#define MIXin_gain			8

#define MIXmicrophone      9
#define MIXspeaker         10

#define MIXleft				1
#define MIXright				2
#define MIXboth				3

/* Mixer output controls for SB16 */

#define CD_OUT					6
#define LINE_OUT				24
#define MIC_OUT				1

#define CD_OUT_L				4
#define CD_OUT_R				2

#define LINE_OUT_L			16
#define LINE_OUT_R			8

/* Mixer input controls for SB16 */

#define FM_IN					0x60
#define LINE_IN				0x18
#define CD_IN					0x06

#define MIC_IN					0x01

#define FM_IN_L				0x40
#define FM_IN_R				0x20

#define LINE_IN_L				0x10
#define LINE_IN_R				0x08

#define CD_IN_L			   0x04
#define CD_IN_R				0x02

#ifndef SB_DRIVE
extern int 	SBport;
extern int 	SBirq;
extern int  SBdma;
extern int	SBdma16;

extern int 	SBtype;
#endif SB_DRIVE

/* High level interface routines follow. */

#define dsp_sample_out(x) { SbWriteByte(DSPSendOneSample); SbWriteByte(x); }
		/* Send one sample directly to the audio DAC. Mono 8-bit only. */

int dsp_reset(void);
		/* Returns Soundblaster found: 	0=none
		 *											1=Soundblaster 1.x         *
		 *											2=Soundblaster 2.0         *
		 *											3=Soundblaster Pro         *
		 *											4=Soundblaster 16/16 ASP   *
		 *											5=Unknown                  */

int dsp_version(void);
		/* Returns the DSP revision of the Soundblaster */

#define dsp_set_playback(a,b,c,d) dsp_set_sample(a,b,c,d)
		/* Alternate name for dsp_set_sample                              */

unsigned dsp_set_record(unsigned speed, int stereo, int bits, int sign);
		/* Returns 0 if recording is impossible, actual rate otherwise.   */

unsigned dsp_set_sample(unsigned speed, int stereo, int bits, int sign);
		/* returns the actual speed, or 0 if invalid for current hardware *
		 * note: 0 response applies to playback _only_. A successful      *
		 * execution of this procedure does NOT ensure the card's ability *
		 * to record at that rate.                                        */

void dsp_set_speed(unsigned *speed);
		/* resets parameter to actual speed */

int dsp_read(void *data);
		/* Reads data from digital sampling into *data.                   *
		 * Possible returns: 0  complete success     (data in *data)		*
		 *                   1  overrun              (data in *data)      *
		 *                   2  starting fresh DMA                        *
		 *                   3  waiting for data                          *
		 *                   4  termination requested                     *

		 * Call with data == NULL to terminate read DMAs.					   */

int dsp_write(void *sample_buf);
		/* returns 0 if buffers are full, or 1 if write was successful.   *
		 * The buffer will be played in its entirity; make sure you send  *
		 * a complete DMA buffer's worth of data. Use NULL to start play  *
		 * back of what is already in DMA buffers.                        */

int dsp_prewrite(void *sample_buf);
		/* adds sample_buf to the DMA playback queue without starting     *
		 * digital playback. Allows you to fill the queue in advance of   *
		 * starting. Returns a 0 when one buffer is left. Use dsp_write   *
		 * to start playback. 															*/

void *dsp_open_buf(void);
		/* returns a pointer to the free next data buffer, to be filled   *
		 * by the calling software. Faster than dsp_write.                */

void dsp_close_buf(void);
		/* signals to the Soundblaster driver that you have finished      *
		 * filling the buffer returned by dsp_open_buf. filled is either  *
		 * zero, to return the buffer unfilled, or 1, if it has been      *
		 * has been completely filled. Partial buffers are not supported. */

int dsp_buffers_free(void);
		/* returns number of free buffers. */

void dsp_callback(void (*handler)(void));
		/* called whenever a buffer is finished playing. NULL to disable. */

int dsp_open(int port, int dma, int irq, int dma16, unsigned bufsize, unsigned numbufs);
		/* returns 0 if insufficient memory is available, or the   *
		 * type of soundblaster found per the previous table.      *
		 * Bufsize ranges from 1K to 31K, numbuf from 2 to 16.	  *
		 * No more than 63K total can be allocated for DMA.	     */

struct dsp_device_caps *dsp_get_device_caps(void);
		/* Returns capabilities of Soundblaster installed in computer. */

void dsp_close(void);
		/* turn off the speaker, reset the DSP, free memory buffers. */

void dsp_speaker(int status);
		/* turn the DSP speaker on and off... nonfunctional on SB16 */

void dsp_pause_dma(void);
		/* Suspend Soundblaster DMA output */

int dsp_continue_dma(void);
		/* Resume suspended DMA. Checks to see if you should be first    *
		 * Returns 1 if successful, 0 if no data to play.                */

int dsp_active(void);
		/* Returns 1 if the DSP is currently busy playing or recording,  *
		 * 0 if it is not. (This returns 0 if the DSP buffers are primed *
       * but not playing yet.)                                         */

int mix_reset(void);
		/* Resets mixer to default values; returns 1 if mixer is active. *
		 * Note: It's not polite to reset the mixer unannounced.         */

void mix_write(int device, int channel, unsigned char level);
		/* devices and channels listed above, level 0-255. */

unsigned char mix_read(int device, int channel);
		/* returns 0-255, MIXboth returns average of two channels. */

void	mix_set_output(int value);
		/* Use output values listed above... add together all relevent. *
		 * Only relevant to Soundblaster 16.                            */

void	mix_set_input(int value);

void  mix_set_sb16_output(int channel, int value);

void  mix_set_sb16_input( int channel, int value);

int sb_get_params(int *port, int *dma, int *irq, int *dma16);
		/* returns values contained in the BLASTER environent string */

/* Low level interface functions and data definitions follow. */

#ifndef SB_DRIVE
extern int SBTimeOut;								/* Timeout value for Soundblaster */
extern unsigned char SBProMixRegs[];		   /* Mixer register addresses for Soundblaster Pro */
extern unsigned char SB16MixRegs[];				/* Mixer register addresses for Soundblaster 16 */

extern int SBintnum;

extern int SBTimeOut;						      /* time to wait for DSP response */

extern char SbOK;

extern char *DMABufferBase;
extern char *DMABuffers[16];

extern unsigned DMABufPage[16];
extern unsigned DMABufOffset[16];

extern unsigned BufLen;
extern unsigned BufCount;

extern char BufQueueHead;
extern char BufQueueTail;

extern void *old_irq_handler;

extern volatile int dsp_overrun;					// Incremented on a record overrun
#endif

/* Soundblaster Basic commands */
#define DSPSendOneSample	0x10
#define DSPGetOneSample		0x20

#define DSPStartDMA			0x14
#define DSPStartADCDMA		0x24

#define DSPSpeakerOn			0xD1
#define DSPSpeakerOff		0xD3

#define DSPGetVersion		0xE1
#define DSPGetCopyright		0xE3

#define DSPSetTimeConstant 0x40

#define DSPPauseDMA			0xD0
#define DSPContinueDMA		0xD4

/* Soundblaster 2.0 and Pro commands */
#define DSPSetHSDMASize		0x48
#define DSPStartHSDMA		0x91

#define DSPStartHSADCDMA	0x99

/* Soundblaster Pro commands */

#define DSPSBProADCStereo	0xA8
#define DSPSBProADCMono		0xA0

/* Soundblaster 16 commands */
#define DSPSB16SetSpeed			0x42

#define DSPSB16Start16DMA		0xB6
#define DSPSB16Start8DMA		0xC6

#define DSPSB16Start16ADCDMA  0xBE
#define DSPSB16Start8ADCDMA	0xCE

#define DSPSB16Stereo			0x20
#define DSPSB16Mono				0x00

#define DSPSB16StereoSign  	0x30
#define DSPSB16MonoSign    	0x10

#define DSPSB16Pause16DMA  	0xD9
#define DSPSB16Pause8DMA   	0xDA

#define DSPSB16Cont16DMA		0x47
#define DSPSB16Cont8DMA			0x45

/* Low level interface routines follow */

void SbWriteByte(unsigned char command);  	/* write one byte to the DSP */
unsigned char SbReadByte(unsigned timeout);	/* receive one byte from DSP */

void SbWriteByteTimeout(unsigned char command, unsigned timeout);

void SbWriteMixerReg(unsigned char reg, unsigned char value);
unsigned char SbReadMixerReg(unsigned char reg);

void interrupt new_irq_handler(void);

void EnableIRQ(char irq);
void DisableIRQ(char irq);



