//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//
// Copyright Information:
// ======================
// 
// Some parts of the source are from the public domain and are not
// copyrighted.
// 
// Some parts of the source bear explicit copyright notices from the
// author and are subject to the conditions listed there by the author.
// 
// The remainder of the source (not already public domain, no explicit
// author's copyright notice) is Copyright 1994 by Torps Productions
// (a loosely associated and ever-growing group of fanatic programmers).
//
// The source code may be copied freely and may be used in other programs
// under the following conditions:
//  It may not be used in a commercial program without prior permission.
//  Please credit the author (in general, credit Cthugha and Torps
//  Productions) as the source of the code.
// 
// This copyright notice is grafted from the Fractint copyright notice.
//
//
// Modifying the code:
// ===================
//
// Feel free to modify this source code, HOWEVER, please send any working
// changes/fixes to me (zaph@torps.apana.org.au) for inclusion in future
// versions of the code.
//
// Distributing the code:
// ======================
//
// Feel free to distribute this code, as long as it is complete and contains
// all copyright information that was included in the original.
//
// Legal Issues:
// =============
//
// What legal issues ???
//
// Come on guys, this is for *fun*, get on with it, make it great, make us
// all famous!!!
//
//                                                zaph, 12May94


#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <math.h>
#include <conio.h>
#include <time.h>
#include <sys\types.h>
#include <sys\stat.h> 
#include <string.h>
#include <memory.h>


#include "sb.h"
#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"
#include "initscrn.h"
#include "maps.h"
#include "translat.h"

#include "audio.h"

#include "mouse.h"

int useinifile=0;
int massageStyle=0;
int minnoise=4;
int was_quiet=0;
int time_to_change=0;
int allow_fft=1,use_fft=0;

extern int peaklevel;
extern int peakframes;

extern char stringtable[20][21];
extern int newwave,usewave;
#define FUNC1 03

void FillLUTBuffer(int pal);
void WriteBuff(unsigned char *buff);

unsigned char LUTbuffer[LUTSIZE];

int table[NUMTABLES][256];
int curtable=0;
int stereo[BUFF_WIDTH][2];
int curflame=0;
int curdisplay=0;
int locked=0;
int debug_mode;

int curpal=0;
unsigned char buff[BUFF_HEIGHT][BUFF_WIDTH];
extern void fill_buff(void);
extern void flame_cro(void);
extern int optind;    /* index of which argument is next      */
extern char *optarg;  /* pointer to argument of current option */
extern int opterr;    /* allow error message  */
extern int getopt(int argc, char *argv[], char *optionS);

static int LoadLuts( char * fn, unsigned char *pal);

int in_vol=-1;
int min_time=200;
int rand_time=750;
int quiet_change=1;
extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);
extern void init_pete(void);

unsigned int tempBuff;
long buffer_size=0x20000L;
char far *voice_buffer;
unsigned  int voice_seg=0;
int debug_mode=0;
unsigned int sample_rate=44100;

extern unsigned vu_rate;

int mouse_inst;

#define UNKNOWN -1
#define SBPRO 0
#define GUS 1
#define OLDSB 2

extern char maptabfile[255];
char stringfile[255];
char inifile[255];
char string[255];

typedef struct {
	int min_time;
	int rand_time;
	int quiet_change;
	int curtable;
	int curflame;
	int curdisplay;
	int locked;
	int minnoise;
	int massageStyle;
	int allow_fft;
	int use_fft;
	int peaklevel;
	int peakframes;
	int newwave;
	int usewave;
	int extra;
	int curpal;
	unsigned int sample_rate;
	int sample_stereo;
	int translate;
} INIsettings;

#define MAX_INI_SETTINGS 50

INIsettings personalINI[MAX_INI_SETTINGS];

int sound_card=UNKNOWN;

int pause=0;

int main(int argc, char *argv[])
{
	union REGS regset;
	int 	i,j,n;
	int doit=0;
	int temp,error=0,help=0;
	int ch;
	int finished;
	long l;
	int iniline=0;
	int current=0,lastmode=0;
	struct find_t dos_f;
	int use_internal_palettes=TRUE;
	int use_external_palettes=TRUE;
	FILE *fp;

	printf("\n\nCTHUGHA v5.0g  Compiled on %s %s\n\n",__DATE__,__TIME__);
	printf("Coded by - The Digital Aasvogel Group - 1994\n\n");
	printf("Original Idea & Code:          Kevin Burfitt (zaph@torps.apana.org.au)\n");
	printf("Flames/Waves/Rotations/SB/FFT: Kevin Burfitt (zaph@torps.apana.org.au)\n");
	printf("SB-Pro(stereo)/GUS/CD player:  Daniel Sachs  (u23783@uic.edu)\n");
	printf("GUS support:                   Jochen Quante (ukr8@rz.uni-karlsruhe.de)\n\n");

	delay(1);

	sound_card = UNKNOWN;

	if( getenv("ULTRASND") )
		 sound_card = GUS;

	time(&l);
	srand(l);

	sprintf(inifile,"CTHUGHA.INI");

	newwave=rand()%NUMWAVES;
	curflame=rand();
	stringfile[0]=0;

	while((ch = getopt(argc,argv,"?OGPXxLlMmCeidSsT:aQ:V:v:R:f:w:p:t:q:b:B:I:")) != EOF) {
		switch(ch) {
			case 'B':
				peaklevel = atoi(optarg);
				printf("Setting peak level to %d\n",peaklevel);
				break;
			case 'b':
				peakframes = atoi(optarg);
				printf("Setting # of peak frames to %d\n",peakframes);
				break;
			case 'q':
				strcpy(stringfile,optarg);
				printf("Reading Strings from %s\n",stringfile);
				break;
			case 'I':
				strcpy(stringfile,optarg);
				printf("Using INI file: %s\n",inifile);
				useinifile=1;
				break;
			case 't':
				strcpy(maptabfile,optarg);
				printf("Using mapping table file:%s\n",maptabfile);
				break;
			case 'P':
				printf("PAS not currently supported - sorry :-(\n");
				printf("Trying OLD-SB code.\n");
				sound_card=OLDSB;

				break;
			case 'd':
				pause=1;
				break;
			case 'Q':
				quiet_change=atoi(optarg);
				if (quiet_change<0)
					quiet_change=0;

				if (quiet_change)
					printf("Setting auto-change on silence to %d frames\n",quiet_change);
				else
					printf("Disabling auto-change on silence\n");

				break;
			case 'L':
				device=LineInput;
				printf("Using Line input\n");
				break;
			case 'v':
				vu_rate = (unsigned)(atol(optarg));

				if (vu_rate<4000)
					vu_rate=0;

				if( vu_rate )
					printf("Setting VU-bar sample rate to: %u\n",vu_rate);
				else
					printf("Setting VU-bar sample rate to current rate\n");

				break;
			case 'V':
				in_vol = atoi(optarg);
				printf("Setting input volume to: %d\n",in_vol);
				break;
		    case 'e':
				use_external_palettes=FALSE;
				printf("Not Using EXTERNAL palettes\n");
				break;
		    case 'i':
				use_internal_palettes=FALSE;
				printf("Not Using INTERNAL palettes\n");
				break;
		    case 'M':
				device=MicInput;
				printf("Using Mic input\n");
				break;
		    case 'C':
				printf("Using CD input\n");
				device=CDInput;
				break;
			case 'T':
				min_time = atoi(optarg);
				min_time = min(min_time,32000);
				min_time = max(min_time,0);
				printf("Minimum frames set to:%d\n",min_time);
				break;
			case 'R':
				rand_time = atoi(optarg);
				rand_time = min(rand_time,32000);
				rand_time = max(rand_time,1);
				printf("random extra frames set to:%d\n",rand_time);
				break;

			case 'G':
				sound_card=GUS;
				break;
			case 'S':
				sound_card=SBPRO;
				break;
			case 'O':
				sound_card=OLDSB;
				break;
			case 's':
				sample_stereo=1;
				printf("Mode set to STEREO\n");
				break;
			case 'm':
				sample_stereo=0;
				printf("Mode set to MONO\n");
				break;
			default:
				printf("Unknown/bad option -%c\n",ch);
				error++;
				break;
			case '?':
				help++;
				break;
			case 'x':
			case 'X':
				debug_mode++;
				printf("Debug Mode (Soundcard not used) (level %d)\n",debug_mode);
				break;
			case 'f':
				curflame = atoi(optarg);
				if (curflame<0)
					curflame=0;
				printf("Starting with flame number %d\n",curflame);
				break;
			case 'p':
				curpal = atoi(optarg);
				if (curpal<0)
					curpal=0;
				printf("Starting with palette number %d\n",curpal);
				break;
			case 'w':
				newwave = atoi(optarg)%NUMWAVES;
				if (newwave<0)
					newwave=0;
				printf("Starting with wave number %d\n",newwave);
				break;
			case 'l':
				locked=1;
				printf("Starting in LOCKED mode\n");
				break;
		}
	 }

	 if( (error)||(help) ) {
		printf("Cthugha: Command line options  ");
		printf("(These are Case sensitive commands)\n");
		printf("  -L,-M,-C  : Use Line/Mic/CD as input\n");
		printf("  -G,-S,-P  : Use GUS/SB/PAS (default: search)\n");
		printf("  -O        : Use Old SB code (for incompatible cards)\n");
		printf("  -s,-m     : Default to STEREO/MONO\n");
		printf("  -i,-e     : Disable Inbuilt/External Palettes\n");
		printf("  -T <num>  : Minimum frames before changing\n");
		printf("  -R <num>  : extra random frames before changing\n");
		printf("  -V <0-255>: Set input volume to <0-255>\n");
		printf("  -v <rate> : VU bar sample rate (Default=4000)\n");
		printf("  -Q <num>  : Number of frames before silence change <def:200>\n");
		printf("  -f <num>  : Start with flame   #<num>\n");
		printf("  -w <num>  : Start with wave    #<num>\n");
		printf("  -p <num>  : Start with palette #<num>\n");
		printf("  -l        : Lock to first wave/flame/palette\n\n");
		printf("  -d        : Pause just before running (usually for debug)\n");
		printf("  -t <fname>: Load alternate Translation table\n");
		printf("  -q <fname>: Load alternate Quiet messages\n");
		printf("  -I <fname>: Load INI file\n");
		printf("  -B <num>  : Set beat peak level to <num>\n");
		printf("  -b <num>  : Set # of beats to <num>   (-ve to disable)\n");

		printf("  -X,-x     : Debug mode (no sound source needed)\n\n");
		exit(1);
	 }


	printf("\n\n");
	if( mouse_inst = mouse_init() )
		printf("Mouse found.\n");
	else
		printf("Mouse not found.\n");


	printf("Initializing Soundcard...\n");

	if (!debug_mode) {
		switch (sound_card) {
			case OLDSB:
				printf("looking for a SB (old code)\n\n");
				printf("**WARNING** this old code may not be stable\n");
				printf("Especially the CD-ROM screen & code...\n\n");
				if (SDK_init()) {
					printf("No Sound source, exiting\n");
					exit(1);
				}
				break;
			case GUS:
				printf("looking for a GUS\n");

				if (GUS_init()) {
					printf("No Sound source, exiting\n");
					exit(1);
				}
				break;
			case SBPRO:
				printf("looking for a Soundblaster\n");
				if (SB_init()) {
					printf("No Sound source, exiting\n");
					exit(1);
				}

				break;

			default: // Try Everything!!
				printf("Scanning for audio cards\n");
				printf("looking for a GUS\n");
				if (!GUS_init()) {
					break;
				}

				printf("looking for a Soundblaster\n");
				if (!SB_init()) {
					printf("(If this is a PAS, you might have to rerun with -P)\n");
					break;
				}

				printf("looking for an old Soundblaster\n");
				if (!SDK_init()) {
					printf("**WARNING** this old code may not be stable\n");
					printf("Especially the CD-ROM screen & code...\n\n");
					break;
				}

				printf("Unable to find a soundcard\n");
				exit(1);
				break;
		}
	}


	if( in_vol > 0 ) {
		in_vol = min(in_vol,255);

		switch( device ) {
			case CDInput:		set_level(MIXcd        ,in_vol); break;
			case LineInput:   set_level(MIXline      ,in_vol); break;
			case MicInput:    set_level(MIXmicrophone,in_vol); break;
		}
	}

	if (stringfile[0]!=0) {
		if ((fp=fopen(stringfile,"r"))!=NULL) {
			i=0;
			fgets(stringfile,254,fp);
			while (!feof(fp) && i<19) {
				stringfile[strlen(stringfile)-1]=0;
				stringfile[20]=0;
				sprintf(stringtable[i],"%s",stringfile);
//				printf("%s\n",stringtable[i]);
				i++;
				fgets(stringfile,254,fp);
			}
			fclose(fp);
			
		}
	}
	printf("Loading Palettes\n");

	if (use_internal_palettes) {
		for (i=0; i<numluts; i++)
			for (j=0; j<255; j++)
				LUTfiles[i][j]=LUTfiles[i][j]>>2;

		for( i=0,j=0;i < 64;i++ ) {
        		LUTfiles[numluts][j++] = i;
        		LUTfiles[numluts][j++] = 0;
        		LUTfiles[numluts][j++] = 0;
		}
		for( i=0;i < 128;i++ ) {
        		LUTfiles[numluts][j++] = 63;
        		LUTfiles[numluts][j++] = 0;
        		LUTfiles[numluts][j++] = i;
		}
		for( i=0;i < 64;i++ ) {
        		LUTfiles[numluts][j++] = 63-i;
				LUTfiles[numluts][j++] = 0;
        		LUTfiles[numluts][j++] = 63;
		}

		i=numluts+1;
	} else {
		numluts=0;
		i=0;
	}
	
	if (use_external_palettes) {
		if (!_dos_findfirst("*.map",_A_NORMAL,&dos_f))
			do {
				printf("reading %s as palette %d\n",dos_f.name,i+1);
				if (LoadLuts(dos_f.name,LUTfiles[i])==0)
					i++;
				else
					printf("problem with palette file: %s\n",dos_f.name);
			} while (!_dos_findnext(&dos_f) && i<MAXLUTS);
		
		numluts=i;
	}

	if (numluts<=0) {
		printf("No Palettes loaded, exiting\n");
		exit(2);
	}

	init_pete();
	init_translate();

	for (temp=0; temp<BUFF_WIDTH; temp++) {
		buff[BUFF_BOTTOM+1][temp]=0;
		buff[BUFF_BOTTOM+2][temp]=0;
	}


	for (j=0; j<NUMTABLES; j++) {
		for (i=0; i<256; i++)
			switch(j) {
				default:
				case 0:
					table[j][i]=abs(128-i)*2;
					break;
				case 1:
					table[j][i]=255-abs(128-i)*2;
					break;
				case 2:
					table[j][i]=i;
					break;
				case 3:
					table[j][i]=255-i;
					break;
				case 4:
					table[j][i]=abs(128-i)+127;
					break;
				case 5:
					table[j][i]=255-abs(128-i)+127;
					break;
				case 6:
					table[j][i]=rand()%256;
					break;
				case 7:
					if (abs(128-i)<64)
						table[j][i]=255;
					else
						table[j][i]=(abs(128-i)*4);
					break;
				case 8:
					table[j][i]=abs(128-i);
					break;
				case 9:
					table[j][i]=255-abs(128-i);
					break;
			}
	}

	lastmode=0;
	current=0;
	finished=0;




	if (inifile[0]!=0) {
		if ((fp=fopen(inifile,"r"))!=NULL) {
			printf("Using %s for all settings\n",inifile);
//			useinifile=1;
			iniline=0;
			fgets(string,254,fp);
			while (iniline<MAX_INI_SETTINGS && !feof(fp)) {
				if (string[0]!=';' && string[2]!=0) {
					n=sscanf(string,"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %u %d %d",
						&personalINI[iniline].min_time,
						&personalINI[iniline].rand_time,
						&personalINI[iniline].quiet_change,
						&personalINI[iniline].curtable,
						&personalINI[iniline].curflame,
						&personalINI[iniline].curdisplay,
						&personalINI[iniline].locked,
						&personalINI[iniline].minnoise,
						&personalINI[iniline].massageStyle,
						&personalINI[iniline].allow_fft,
						&personalINI[iniline].use_fft,
						&personalINI[iniline].peaklevel,
						&personalINI[iniline].peakframes,
						&personalINI[iniline].newwave,
						&personalINI[iniline].usewave,
						&personalINI[iniline].extra,
						&personalINI[iniline].curpal,
						&personalINI[iniline].sample_rate,
						&personalINI[iniline].sample_stereo,
						&personalINI[iniline].translate);


					if (rand_time<=0)
						rand_time=1;

					if (n==20)
						iniline++;
					else
						printf("Bad INI line: %s",string);
				} else {
					printf("%s",string);
				}
				fgets(string,254,fp);
			}
			fclose(fp);
			printf("%d configurations read\n",iniline);
		} else {
			useinifile=0;
			printf("Cannot find INI file: %s\n",inifile);
		}
	}

	if (pause) {
		printf("\nPausing, press any key to continue:");
		getch();
	} else {
		delay(2000);
	}

	regset.x.ax = 0x0013;	
	int86(0x10, &regset, &regset);

	curpal=curpal%numluts;
	curflame=change_flame(curflame);
	change_wave(newwave);
	curdisplay=0;

	FillLUTBuffer(curpal);


	if (iniline>0) {
		n=rand()%iniline;

		min_time=personalINI[n].min_time;
		rand_time=personalINI[n].rand_time;
		quiet_change=personalINI[n].quiet_change;
		curtable=personalINI[n].curtable;
		curflame=personalINI[n].curflame;
		curdisplay=personalINI[n].curdisplay;
		locked=personalINI[n].locked;
		minnoise=personalINI[n].minnoise;
		massageStyle=personalINI[n].massageStyle;
		allow_fft=personalINI[n].allow_fft;
		use_fft=personalINI[n].use_fft;
		peaklevel=personalINI[n].peaklevel;
		peakframes=personalINI[n].peakframes;
		newwave=personalINI[n].newwave;
		usewave=personalINI[n].usewave;
//	extra=personalINI[n].extra;
		curpal=personalINI[n].curpal;
		sample_rate=personalINI[n].sample_rate;
		sample_stereo=personalINI[n].sample_stereo;
		translate=personalINI[n].translate;

		FillLUTBuffer(curpal%numluts);
		curflame=change_flame(curflame);
		change_wave(usewave);

	}


	while (!finished) {

		switch (current) {
			case 0:
				time_to_change=0;

				for (temp=0; temp<BUFF_WIDTH; temp++) {
					buff[BUFF_BOTTOM+1][temp]=0;
					buff[BUFF_BOTTOM+2][temp]=0;
				}
				flame_cro();
				doit=0;
				break;
			default:
			case 1:  // Change everything (In Theory)

				current=0;
				if (iniline<=0)  // No INI lines, always random
					n=0;   
				else if (!useinifile) {
					n=rand()%2;  // Default INI file, plus random
				} else {
					n=1;         // Personal INI file, no random
				}

				if (!n) {
					time_to_change=0;
					curtable=rand()%NUMTABLES;
					FillLUTBuffer(rand()%numluts);
					curflame=change_flame(rand());
					change_wave(rand()%NUMWAVES);
					curdisplay=rand()%NUMDISPLAYS;
					if ((rand()%5)==0)
						translate = !translate;
					if ((rand()%5)==0)
						use_fft=!use_fft;
					doit=1;
				} else {
					doit=1;
					time_to_change=0;

					n=rand()%iniline;

					min_time=personalINI[n].min_time;
					rand_time=personalINI[n].rand_time;
					quiet_change=personalINI[n].quiet_change;
					curtable=personalINI[n].curtable;
					curflame=personalINI[n].curflame;
					curdisplay=personalINI[n].curdisplay;
					locked=personalINI[n].locked;
					minnoise=personalINI[n].minnoise;
					massageStyle=personalINI[n].massageStyle;
					allow_fft=personalINI[n].allow_fft;
					use_fft=personalINI[n].use_fft;
					peaklevel=personalINI[n].peaklevel;
					peakframes=personalINI[n].peakframes;
					newwave=personalINI[n].newwave;
					usewave=personalINI[n].usewave;
//					extra=personalINI[n].extra;
					curpal=personalINI[n].curpal;
					sample_rate=personalINI[n].sample_rate;
					sample_stereo=personalINI[n].sample_stereo;
					translate=personalINI[n].translate;

					FillLUTBuffer(curpal%numluts);
					curflame=change_flame(curflame);
					change_wave(usewave);

				}
				break;
		}

		switch (z_keypress()) {
			case Z_NOKEY:
				if (doit) {
					current=0;
					doit=0;
				} else {
					if (!locked) {
						current=rand()%NUMCOMBINATIONS+1;
					}
				}
				break;
			case Z_ESC:
				finished=1;
				break;

			case Z_FFT:
				use_fft=!use_fft;
//				allow_fft= !allow_fft;
				break;
			case Z_NOISE_DN:
				minnoise=max(minnoise-1,0);
				break;

			case Z_SAMPLE_DN:
				sample_rate -= 1000;
				break;

			case Z_NOISE_UP:
				minnoise=min(minnoise+1,127);
				break;

			case Z_SAMPLE_UP:
				sample_rate += 1000;
				break;

			case Z_STEREO:
				sample_stereo = !sample_stereo;
				sample_rate = 0;
				break;

			case Z_CD:
//				if (sound_card != OLDSB)
					cd_player();
				break;

			case Z_WAVE:
				next_wave();
				break;

			case Z_FLAME:
				curflame++;
				curflame=change_flame(curflame);
				break;

			case Z_PALETTE:
				FillLUTBuffer((curpal+1)%numluts);
				break;

			case Z_TABLE:
				curtable=(curtable+1)%NUMTABLES;
				break;

			case Z_DISPLAY:
				curdisplay=(curdisplay+1)%NUMDISPLAYS;
				break;

			case Z_OTHERKEY:
			case Z_SPACE:
				current=rand()%NUMCOMBINATIONS+1;
				break;

			case Z_NEWWAVE:
				change_wave(newwave);
				break;

			case Z_MASSAGE:
				massageStyle = (massageStyle+1)%NUMMASSAGES;
				break;

			case Z_LOCK:
				locked=(!locked);
				if (!locked)
					current=rand()%NUMCOMBINATIONS+1;
				break;

			case Z_HELP:
				regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
				int86(0x10, &regset, &regset);

				help_screen();

				gotoxy(0,24);
				printf("Current: wave=%d, flame=%d, sample rate=%ld, %s, minnoise=%d",usewave,curflame,(long)sample_rate,sample_stereo ? "stereo" : "mono",minnoise);

				while (z_keypress()==Z_NOKEY)
					;

				regset.x.ax = 0x0013;
				int86(0x10, &regset, &regset);

				FillLUTBuffer((curpal)%numluts);
				break;

			case Z_TRANSLATE:
				translate = !translate;
				break;

			case Z_ADDINI:

				if ((fp=fopen(inifile,"a"))!=NULL) {
					regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
					int86(0x10, &regset, &regset);

					printf("Adding to %s\n",inifile);
					printf("Adding to current settings list\n");
					if (iniline>=MAX_INI_SETTINGS) {
						printf("Too many settings.. cannot save, sorry :-)\n");
					} else {

						personalINI[iniline].min_time=min_time;
						personalINI[iniline].rand_time=rand_time;
						personalINI[iniline].quiet_change=quiet_change;
						personalINI[iniline].curtable=curtable;
						personalINI[iniline].curflame=curflame;
						personalINI[iniline].curdisplay=curdisplay;
						personalINI[iniline].locked=locked;
						personalINI[iniline].minnoise=minnoise;
						personalINI[iniline].massageStyle=massageStyle;
						personalINI[iniline].allow_fft=allow_fft;
						personalINI[iniline].use_fft=use_fft;
						personalINI[iniline].peaklevel=peaklevel;
						personalINI[iniline].peakframes=peakframes;
						personalINI[iniline].newwave=newwave;
						personalINI[iniline].usewave=usewave;
						personalINI[iniline].extra=0;
						personalINI[iniline].curpal=curpal;
						personalINI[iniline].sample_rate=sample_rate;
						personalINI[iniline].sample_stereo=sample_stereo;
						personalINI[iniline].translate=translate;

						fprintf(fp,"; Auto Added from Cthugha\n");
						fprintf(fp,"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %u %d %d\n",
						personalINI[iniline].min_time,
						personalINI[iniline].rand_time,
						personalINI[iniline].quiet_change,
						personalINI[iniline].curtable,
						personalINI[iniline].curflame,
						personalINI[iniline].curdisplay,
						personalINI[iniline].locked,
						personalINI[iniline].minnoise,
						personalINI[iniline].massageStyle,
						personalINI[iniline].allow_fft,
						personalINI[iniline].use_fft,
						personalINI[iniline].peaklevel,
						personalINI[iniline].peakframes,
						personalINI[iniline].newwave,
						personalINI[iniline].usewave,
						personalINI[iniline].extra,
						personalINI[iniline].curpal,
						personalINI[iniline].sample_rate,
						personalINI[iniline].sample_stereo,
						personalINI[iniline].translate);
						fclose(fp);

						iniline++;
					}

				} else
					printf("Cannot open INI file: %s\n",inifile);

			printf("Press a key to continue:");

			while (z_keypress()==Z_NOKEY)
				;


			regset.x.ax = 0x0013;
			int86(0x10, &regset, &regset);

			FillLUTBuffer((curpal)%numluts);

			default:
				break;
		}
	}



	regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
	int86(0x10, &regset, &regset);

	if (!debug_mode)
		close_audio();

	show_credits();
	getch();
	quit_screen();

    return 0;
}

#if 0
void FillLUTBuffer(int pal)
{
    /* fills the buffer with 8 bit values */

        curpal=pal%numluts;

        memcpy(LUTbuffer,LUTfiles[curpal],768);


    _asm {
            push di;
            push si;
            push ds;
            push ss;
            push sp;
            push bp;

    mov     dx,0x03da
WaitVS:
    in      al,dx
    test    al,0x08
    jz      WaitVS  ;vertical sync is active high (1 = active)


            mov ax,1012h;
            mov bx,0;
            mov cx,100h;
            mov dx,SEG LUTbuffer;
            mov es,dx;
            mov dx,OFFSET LUTbuffer;
            int 10h;
            pop bp;
            pop sp;
            pop ss;
            pop ds;
            pop si;
            pop di;
    }
}

#else
void FillLUTBuffer(int pal)
{
	 /* fills the buffer with 8 bit values */

	int i;

	char *p;

	curpal=pal%numluts;

	memcpy(LUTbuffer,LUTfiles[curpal],768);

	outp(0x3c6,0xff);

	p = &LUTbuffer;

	for(i=0;i<256;i++)
	{
		outp(0x3c8,i);
		outp(0x3c9,(*p++));
		outp(0x3c9,(*p++));
		outp(0x3c9,(*p++));
	}

}
#endif

static int LoadLuts( char * fn, unsigned char *pal)
{
	FILE *f;
	int n;
	unsigned        r, g, b, index;
	char	line[160];
	char	temp[81];

	strcpy (temp,fn);
	if (strchr(temp,'.') == NULL) /* Did name have an extension? */
		strcat(temp,".map");  /* No? Then add .map */

	f = fopen( temp, "r" );
	if (f == NULL) {
		return 1;
	}
	for( index = 0; index < 256; index++ ) {
		if (fgets(line,100,f) == NULL)
			return 1;
		n=sscanf( line, "%u %u %u", &r, &g, &b );
		if (n<3)
			return 1;
		/** load global dac values **/
		pal[index*3]   = (r%256) >> 2;     /* maps default to 8 bits */
		pal[index*3+1] = (g%256) >> 2;     /* DAC wants 6 bits */
		pal[index*3+2] = (b%256) >> 2;
	}
	fclose( f );
	if (index==0) {
		pal[0]=pal[1]=pal[2]=0;
		index++;
	}

	while (index < 256)  { /* zap unset entries */
		pal[index*3] =  pal[(index-1)*3];
		pal[index*3+1] = pal[(index-1)*3+1];
		pal[index*3+2] = pal[(index-1)*3+2]; 
		++index;
	}
	return 0;
}


