/**************************************************************************/
/*  EMS functions v1.0                                                    */
/*------------------------------------------------------------------------*/
/*  Copied down from the 'DOS Programmer's Reference (2nd Edition)' by    */
/*  Terry Dettmann and revised by Jim Kyle.                               */
/*  I had better sit down sometime and optimize these functions - so      */
/*  much could be gained by converting to pretty much 100% assembler :-)  */
/**************************************************************************/
#include <dos.h>

#define FALSE 0
#define TRUE !FALSE

#define EMM 0x67        // That's the interrupt number for the EMS functions

char far* emmbase;

// Tests for the presence in memory of the Expanded Memory Manager
int emmtest(void)
{
  union REGS regs;
  struct SREGS sregs;
  short result;
  long handle;

  regs.h.ah = 0x3D;             // Open file
  regs.h.al = 0;                // Read mode only
  regs.x.dx = (int)"EMMXXXX0";  // File name
  sregs.ds = _DS;               // Set the DS register
  intdosx(&regs, &regs, &sregs);

  handle = regs.x.ax;           // File handle
  if (result = (regs.x.cflag == 0)) {
    regs.h.ah = 0x3E;           // Close file, I guess
    regs.x.bx = handle;
    intdos(&regs, &regs);
  }

  return result;
}

// Tests for the functionality of the Expanded Memory Manager and determines
// the base address of the page frame
int emmok(void)
{
  union REGS regs;

  regs.h.ah = 0x40;             // Get manager status
  int86(EMM, &regs, &regs);
  if (regs.h.ah != 0) return FALSE;

  regs.h.ah = 0x41;             // Get page frame segment
  int86(EMM, &regs, &regs);
  if (regs.h.ah != 0) return FALSE;

  emmbase = (char*)MK_FP(regs.x.bx, 0);
  return TRUE;
}

// Requests a designated number of pages from the Expanded Memory Manager
long emmalloc(int n)
{
  union REGS regs;

  regs.h.ah = 0x43;             // Get handle and allocate memory
  regs.x.bx = n;
  int86(EMM, &regs, &regs);
  if (regs.h.ah != 0) return (-1);

  return (regs.x.dx);
}

// Maps an expanded memory page into the page frame
int emmmap(long handle, int phys, int page)
{
  union REGS regs;

  regs.h.ah = 0x44;             // Map memory
  regs.h.al = page;
  regs.x.bx = phys;
  regs.x.dx = handle;
  int86(EMM, &regs, &regs);

  return (regs.h.ah == 0);
}

// Moves data into a designated page in the page frame
void emmmove(int page, char *str, int n)
{
  char far *ptr = emmbase + page*16384;
  while(n-- > 0) *ptr++ = *str++;
}

// Gets data from a designated page in the page frame
void emmget(int page, char *str, int n)
{
  char far *ptr = emmbase + page*16384;
  while (n-- > 0) *str++ = *ptr++;
}

// Returns control of the expanded memory manager handle to the
// Expanded Memory Manager
int emmclose(long handle)
{
  union REGS regs;

  regs.h.ah = 0x45;             // Release handle
  regs.x.dx = handle;
  int86(EMM, &regs, &regs);

  return (regs.h.ah == 0);
}
