{
  This is the Pascal equivalent of the external ASM module that contains the
  mixing routine. As I made the ASM routine first, some variables in this
  translated version have somewhat strange names (_ebx ;-) ),
  besides the code is quite ugly (gotos). This is because the ASM routine
  was written in ASM from scratch (it was not a translation from a high level
  language routine).
  Note that this routine is simplier than the ASM one: the pascal routine
  has no Volume Zero Optimisations, and the stereo version of the mixer is
  not included. Maybe I'll add a pascal stereo mixer later on...
}
{
  Zis routine bugs w/ xenolog1.mod
}

{ The following variables are used only by the mixer: }
VAR  MixIndex, MixLoopCnt, TMixIndex: Word;

Procedure MONO_MIX_8BIT(NrB2Mix: Word);
VAR
  _ebx: LongInt;
  chn : Byte;
  tmp : LongInt;
  smp : PByteBuffer;
  ts  : ShortInt;
  TmpAmp: Word;

Label _2_SkipMix;
BEGIN
{Clean the buffer: ----------------------------------------------------------}
  For TMixIndex:=0 to NrB2Mix-1 do TMixBuffer^[TMixIndex]:=0;

{ Now mix all the channels together: ----------------------------------------}
  For Chn:=1 to ModInfo.NrChannels do
  Begin
    TmpAmp:=Amplify*MixInfo[chn].Vol;
    MixLoopCnt:=NrB2Mix; TMixIndex:=0;           { update/init loop counters }
    If MixInfo[chn].OnMix then                      { Should I mix this chn? }
    Repeat
      _ebx:=MixInfo[chn].RealIndex shr 16;
      Inc(MixInfo[chn].RealIndex, MixInfo[chn].IncEr);
      If _ebx>=MixInfo[chn].Length then
        If MixInfo[chn].RepeatSample then
             MixInfo[chn].RealIndex:=LongInt(MixInfo[chn].RepeatOffset) shl 16
        Else Begin MixInfo[chn].OnMix:=False; goto _2_SkipMix; End
      Else
        Begin                 { push word on buffer & clean High Word of it: }
          smp:=ptr(MixInfo[chn].SampleSeg, MixInfo[chn].SampleOfs);
          tmp:=ShortInt(smp^[_ebx]);

          tmp:=tmp*TmpAmp;
          if tmp>MaxA then tmp:=MaxA;
          if tmp<MinA then tmp:=MinA;

          Inc(TMixBuffer^[TMixIndex], tmp);
          dec(MixLoopCnt); Inc(TMixIndex);  { increment Index of temp buffer }
        End;
    Until MixLoopCnt = 0;
_2_SkipMix:
  End;

{ And now modify the mixed buffer so we can play it: (put res. down to 8bit) }
  For TMixIndex:=0 to NrB2Mix-1 do
  Begin
    tmp:=TMixBuffer^[TMixIndex] div ((64*16)*ModInfo.NrChannels);
    ts :=ShortInt(tmp);
    MixBuffer^[MixIndex]:=Byte(ts) XOR 128;
    Inc(MixIndex);
  End;
END; {MONO_MIX_8BIT}

{****************************************************************************}

Procedure MONO_MIX_8BIT_I(NrB2Mix: Word); {interpolates}
VAR
  _ebx: LongInt;
  chn : Byte;
  tmp : LongInt;
  smp : PByteBuffer;
  ts  : ShortInt;
  TmpAmp: Word;
  y1, y2,
  Yd    : Integer;
  A, Y, X: LongInt;

Label _2_SkipMix;
BEGIN
{Clean the buffer: ----------------------------------------------------------}
  For TMixIndex:=0 to NrB2Mix-1 do TMixBuffer^[TMixIndex]:=0;

{ Now mix all the channels together: ----------------------------------------}
  For Chn:=1 to ModInfo.NrChannels do
  Begin
    TmpAmp:=Amplify*MixInfo[chn].Vol;
    MixLoopCnt:=NrB2Mix; TMixIndex:=0;           { update/init loop counters }
    If MixInfo[chn].OnMix then                      { Should I mix this chn? }
    Repeat
      _ebx:=MixInfo[chn].RealIndex shr 16;
      X:=WORD(MixInfo[chn].RealIndex AND $FFFF);
      Inc(MixInfo[chn].RealIndex, MixInfo[chn].IncEr);
      If _ebx>=MixInfo[chn].Length then
        If MixInfo[chn].RepeatSample then
             MixInfo[chn].RealIndex:=LongInt(MixInfo[chn].RepeatOffset) shl 16
        Else Begin MixInfo[chn].OnMix:=False; goto _2_SkipMix; End
      Else
        Begin                 { push word on buffer & clean High Word of it: }
          smp:=ptr(MixInfo[chn].SampleSeg, MixInfo[chn].SampleOfs);
          Y1:=ShortInt(smp^[_ebx  ]);
          Y2:=ShortInt(smp^[_ebx+1]);
          Yd:=Y2-Y1;
          A :=X*Integer(Yd);
          Y :=(LongInt(Y1) shl 8 + A div $100) div $100;
{          asm
            mov   ax, [WORD A]

            mov   al, [y1]
            shl   ax, 8


          end;}

          tmp:=Y;
          {tmp:=ShortInt(smp^[_ebx]);}

          tmp:=tmp*TmpAmp;

          if tmp>MaxA then tmp:=MaxA;
          if tmp<MinA then tmp:=MinA;
          Inc(TMixBuffer^[TMixIndex], tmp);
          dec(MixLoopCnt); Inc(TMixIndex);  { increment Index of temp buffer }
        End;
    Until MixLoopCnt = 0;
_2_SkipMix:
  End;

{ And now modify the mixed buffer so we can play it: (put res. down to 8bit) }
  For TMixIndex:=0 to NrB2Mix-1 do
  Begin
    tmp:=TMixBuffer^[TMixIndex] div (Word(64)*Word(16{amplify})*ModInfo.NrChannels);
    ts :=ShortInt(tmp);
    MixBuffer^[MixIndex]:=Byte(ts) XOR 128;
    Inc(MixIndex);
  End;
END; {MONO_MIX_8BIT}

{****************************************************************************}

Procedure _SWAPBUFFERS;
VAR
  temp: PByteBuffer;
BEGIN { swap mix & play buffers }
  temp:=MixBuffer; MixBuffer:=PlayBuffer; PlayBuffer:=temp;
END; {_SWAPBUFFERS}

{****************************************************************************}

Procedure _UPDATEBPM;
BEGIN
  Inc(Timing.count);                              { Yes, update bpm (and FX) }
  if (Timing.count<Timing.speed) or (Timing.PatternDelay>0) then
                                                   UpDateMultipleStepsEffects
  Else
  Begin
    WaitState:=True; Timing.Count:=0; UpDateNotes;{ SBUpDateMultipleStepsEffects; }
  End;
END; {_UPDATEBPM}

{****************************************************************************}

Procedure _SBMONO_MIXER;
VAR X: Word;
BEGIN
  MixIndex:=0;
  X:=CallBpm-MixCount;
  If X>MixBuflen then
    Begin Inc(MixCount, MixBuflen); MONO_MIX_8BIT(MixBuflen); End
  Else
    Begin
      MONO_MIX_8BIT(X); X:=MixBuflen-X; MixCount:=0; _UPDATEBPM;
      If X>=Callbpm then
      Repeat
        MONO_MIX_8BIT(CallBpm); _UPDATEBPM; Dec(X, CallBpm);
      Until X<CallBpm;
      If X<>0 then Begin MixCount:=X; MONO_MIX_8BIT(X); End;
    End;
END; {_SBMONO_MIXER}

{****************************************************************************}

Procedure _SBMONO_MIXER_I;
VAR X: Word;
BEGIN
  MixIndex:=0;
  X:=CallBpm-MixCount;
  If X>MixBuflen then
    Begin Inc(MixCount, MixBuflen); MONO_MIX_8BIT_I(MixBuflen); End
  Else
    Begin
      MONO_MIX_8BIT_I(X); X:=MixBuflen-X; MixCount:=0; _UPDATEBPM;
      If X>=Callbpm then
      Repeat
        MONO_MIX_8BIT_I(CallBpm); _UPDATEBPM; Dec(X, CallBpm);
      Until X<CallBpm;
      If X<>0 then Begin MixCount:=X; MONO_MIX_8BIT_I(X); End;
    End;
END; {_SBMONO_MIXER}






















Procedure MONO_MIX_8BIT_BAK(NrB2Mix: Word);
VAR
  _ebx: LongInt;
  chn : Byte;
  tmp : LongInt;
  smp : PByteBuffer;
  ts  : ShortInt;

Label _2_SkipMix;
BEGIN
{Clean the buffer: ----------------------------------------------------------}
  For TMixIndex:=0 to NrB2Mix-1 do TMixBuffer^[TMixIndex]:=0;

{ Now mix all the channels together: ----------------------------------------}
  For Chn:=1 to ModInfo.NrChannels do
  Begin
    MixLoopCnt:=NrB2Mix; TMixIndex:=0;           { update/init loop counters }
    If MixInfo[chn].OnMix then                      { Should I mix this chn? }
    Repeat
      _ebx:=MixInfo[chn].RealIndex shr 16;
      Inc(MixInfo[chn].RealIndex, MixInfo[chn].IncEr);
      If _ebx>=MixInfo[chn].Length then
        If MixInfo[chn].RepeatSample then
             MixInfo[chn].RealIndex:=LongInt(MixInfo[chn].RepeatOffset) shl 16
        Else Begin MixInfo[chn].OnMix:=False; goto _2_SkipMix; End
      Else
        Begin                 { push word on buffer & clean High Word of it: }
          smp:=ptr(MixInfo[chn].SampleSeg, MixInfo[chn].SampleOfs);
          tmp:=(smp^[_ebx]); tmp:=tmp*MixInfo[chn].Vol;
{          if tmp<0 then TextColor(Magenta) else TextColor(Yellow); Write('&');}
          Inc(TMixBuffer^[TMixIndex], tmp);
          dec(MixLoopCnt); Inc(TMixIndex);  { increment Index of temp buffer }
        End;
    Until MixLoopCnt = 0;
_2_SkipMix:
  End;

{ And now modify the mixed buffer so we can play it: (put res. down to 8bit) }
  For TMixIndex:=0 to NrB2Mix-1 do
  Begin
    tmp:=TMixBuffer^[TMixIndex] div (Word(64)*ModInfo.NrChannels);
    ts :=ShortInt(tmp);
    MixBuffer^[MixIndex]:=Byte(tmp);
    Inc(MixIndex);
  End;
END; {MONO_MIX_8BIT}

