// c_instrument.h: interface for the c_instrument class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_INSTRUMENT_H__2691C104_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_INSTRUMENT_H__2691C104_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_instrument
{
public:
	c_instrument(signed long num);
	c_instrument(FILE *module_file);
	c_instrument(istream &is, int format);
	virtual ~c_instrument();
	const char *get_name();
	const char *get_dos_name();
	signed long get_new_note_action();
	signed long get_duplicate_check_type();
	signed long get_duplicate_check_action();
	signed long get_fadeout();
	signed long get_pitch_panning_separation();
	signed long get_pitch_panning_center();
	signed long get_volume();
	signed long get_panning();
	signed long get_random_volume_variation();
	signed long get_random_panning_variation();
	p_note_sample get_note_sample_record(signed long note);
	signed long get_note(signed long note);
	signed long get_sample(signed long note);
	p_envelope get_volume_envelope();
	p_envelope get_panning_envelope();
	p_envelope get_pitch_envelope();

private:
	void init_variables();
	char m_name[26] ; 
	char m_dos_file_name[12] ;
	signed long m_new_note_action ; 
	signed long m_duplicate_check_type ; 
	signed long m_duplicate_check_action ; 
	signed long m_fadeout ;
	signed long m_pitch_pan_separation ; 
	signed long m_pitch_pan_center ;
	signed long m_global_volume ; 
	signed long m_default_panning ; 
	signed long m_random_volume_variation ; 
	signed long m_random_panning_variation ;
	p_note_sample m_note_sample_keyboard_table [120] ; 
	p_envelope m_volume_envelope ;
	p_envelope m_panning_envelope ;
	p_envelope m_pitch_envelope ;
};


#endif // !defined(AFX_C_INSTRUMENT_H__2691C104_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
