// c_wav.h: interface for the c_wav class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_WAV_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_WAV_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_wav  
{
public:
	c_wav(char *wav_file_name, signed long sampling_rate);
	virtual ~c_wav();
	bool fill_buffer(double *buffer, signed long buffer_length, unsigned long &position);
	void set_mixing_volume(double mixing_volume_left, double mixing_volume_right, double panning);
	char *get_name();
	void rewind() ;

private:
	unsigned long m_length ;
	signed long m_format ; /* should be 1 */
	bool m_stereo ;
	unsigned long m_sampling_frequency ;
	bool m_16bit ;
	double m_volume_left ;
	double m_volume_right ;
	unsigned long m_beginning ;
	unsigned long m_position ;
	unsigned long m_frac_position ;
	unsigned long m_step_length ;
	double m_left_value ;
	double m_next_left_value ;
	double m_right_value ;
	double m_next_right_value ;
	signed long m_step_factor ;

	void load(istream &is) ;
	void load(FILE *wav_file) ;
	void fill_16_stereo(double *buffer, const double *buffer_end)	;
	void fill_16_mono(double *buffer, const double *buffer_end)	;
	void fill_8_stereo(double *buffer, const double *buffer_end)	;
	void fill_8_mono(double *buffer, const double *buffer_end) ;
	ifstream *m_ifs ;

	double get_value();
	void fill_values();
	char *m_name ;
	char *m_buffer ;
};

#endif // !defined(AFX_C_WAV_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
