/* types.h */
/*
     PLAY_ITW.EXE v0.02b : Player for Impulse Tracker modules files
     Copyright (C) 1997  Olivier AUMAGE
     E-mail : Olivier.Aumage@ens-lyon.fr
     Web : http://www.ens-lyon.fr/~oaumage/

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __types_h__
#define __types_h__


/* 
  *                                         *
   This file declares the structures for
   representing modules and module elements
   into memory 
  *                                         *
*/
   
/* Data structures */
/*=================*/


/* note_sample */
/*-------------*/

typedef struct s_note_sample
{
  unsigned char note ; /* note of the sample */
  /* range from 0 to 119 (C-0 to B-9) */

  unsigned char sample ; /* no of sample */
  /* range from 1 to 99 */

} note_sample, *p_note_sample ;


/* envelope_node */
/*---------------*/

typedef struct s_envelope_node
{
  signed short y_value ; /* y value of the node */
  /* range from :
     - 0 to 64 for volume
     - -32 to 32 for panning and pitch */
   
  unsigned short tick ; /* tick number */   
  /* range from 0 to 999 */
} envelope_node, *p_envelope_node ;


/* envelope */
/*----------*/

typedef struct s_envelope
{
  int envelope_on_off ; /* envelope state */
  /* 0 -> off
     1 -> on */
  
  int loop_on_off ; /* loop state */
  /* 0 -> off
     1 -> on */
     
  int sustain_loop_on_off ; /* sustain loop state */
  /* 0 -> off
     1 -> on */
     
  unsigned char number_of_points ; 
  /* number of points constituting the envelope, <= 25 */
  
  unsigned char loop_begin ; 
  
  unsigned char loop_end ; 
  
  unsigned char sustain_loop_begin ;
  
  unsigned char sustain_loop_end ;

  unsigned short last_tick ;

  unsigned short loop_begin_tick ;

  unsigned short loop_end_tick ;

  unsigned short sustain_loop_begin_tick ;

  unsigned short sustain_loop_end_tick ;

  envelope_node nodes[25] ;
} envelope, *p_envelope ;
    

/* instrument */
/*------------*/
typedef struct s_instrument
{
  char name[26] ; /* name of the instrument */

  char dos_file_name[12] ; /* file name of the instrument */
  
  unsigned char new_note_action ; 
  /* 0 = cut
     1 = Note Off
     2 = Continue
     3 = Note Fade */
     
  unsigned char duplicate_check_type ; 
  /* 0 = Off
     1 = Note
     2 = Sample
     3 = Instrument */
          
  unsigned char duplicate_check_action ; 
  /* 0 = Cut
     1 = Note Off
     2 = Note Fade */
     
  unsigned short fadeout ;
  /* applied when :
     - Note Fade NNA selected and triggered
     - Note Off is select with no volume envelope
     - Volume envelope end is reached */
     
  signed char pitch_pan_separation ; 
  /* range from -32 to + 32 */
  
  unsigned char pitch_pan_center ;
  /* range from 0 to 119 (C-0 to B-9) */

  unsigned char global_volume ; 
  /* range from 0 to 128 */
  
  unsigned char default_panning ; 
  /* 0 to 64 : panning position
     128 : no default panning */
     
  unsigned char random_volume_variation ; 
  /* range : ??? */
  
  unsigned char random_panning_variation ; 
  /* range : ??? */

  note_sample note_sample_keyboard_table [120] ; /* note_sample */
  /* note/sample associated with each
     instrument note, see note_sample above */  
     
  envelope volume_envelope ;
  unsigned char *interpolated_volume_envelope ;

  envelope panning_envelope ;
  signed char *interpolated_panning_envelope ;

  envelope pitch_envelope ;
  signed char *interpolated_pitch_envelope ;

} instrument, *p_instrument ;


/* sample */
/*--------*/

typedef struct s_sample
{
  char name[26] ; /* name of the sample */

  char dos_file_name[12] ; /* file name of the sample */
  
  unsigned char global_volume ; 
  /* Global volume for instrument
     range from 0 to 64 */  
     
  int is_16_bits_sample ;   
  /* 1 = yes
     0 = no, 8 bits sample */
     
  int is_stereo_sample ;   
  /* 1 = yes, but not supported by IT for now
     0 = no, mono sample */
     
  int use_loop ;
  /* 1 = yes, use loop
     0 = no */
     
  int use_sustain_loop ;
  /* 1 = yes, use sustain loop
     0 = no */
     
  int loop_direction ;
  /* 1 = Ping Pong loop
     0 = Forward loop */
     
  int sustain_loop_direction ;
  /* 1 = Ping Pong sustain_loop
     0 = Forward sustain_loop */
     
  int is_signed_sample ;
  /* 1 = yes
     0 = no */

  unsigned char default_volume ;
  /* range ??? */
  
  unsigned long length ; /* length of the sample */
  /* the length is not in byte but in samples */
     
  unsigned long loop_begin ;
  /* in samples */

  unsigned long loop_end ;
  /* no of the sample AFTER the end of loop */

  unsigned long C5_speed ; /* C-5 note speed in bytes/second */
  /* range from 0 to 9999999
     seems strange that the speed is not in samples/second */

  double adjusted_C5_speed ; /* C5 adjusted for output */

  unsigned long sustain_loop_begin ;
  /* in samples */

  unsigned long sustain_loop_end ;
  /* no of the sample AFTER the end of the sustain loop */

  unsigned char vibrato_speed ;
  /* range from 0 to 64 */

  unsigned char vibrato_depth ;
  /* range from 0 to 64 */

  unsigned char vibrato_rate  ;
  /* range from 0 to 64 */

  unsigned char vibrato_waveform_type ;
  /* 0 = sine wave
     1 = ramp down
     2 = square Wave
     3 = random (then speed is irrelevant) */

  /* see ITTECH for vibrato depth processing */


  double *sample_data ; /* floating point sample data */

} sample, *p_sample ;


/* pattern */
/*---------*/

typedef struct s_pattern
{
  unsigned short length ; /* length of the pattern */
  
  unsigned short number_of_rows ;
  
  unsigned char *packed_pattern_data ;
  /* IT patterns are stored in packed form.
     See ITTECH for detail about unpacking. */

} pattern, *p_pattern ;


/* module */
/*--------*/

typedef struct s_module
{
  char name[26] ; /* module name */

  unsigned short number_of_orders ;
  
  unsigned short number_of_instruments ;
  
  unsigned short number_of_samples ;
  
  unsigned short number_of_patterns ;
  
  int is_stereo ;
  /* 1 = stereo module
     0 = mono module */
     
  int use_instruments ;
  /* 1 = use instruments
     0 = use samples */
     
  int type_of_slides ;
  /* 1 = linear slides
     0 = Amiga slides */
     
  int old_effects ;
  /* 1 = old effects
     0 = IT effects */
     
  int g_effect ;

  int has_a_message ;
  /* 1 = yes
     0 = no */
     
  char *message ;
  
  unsigned char global_volume ;
  /* range from 0 to 128 */
  
  unsigned char mixing_volume ;
  /* range from 0 to 128 */
  
  unsigned char initial_speed ;
  
  unsigned char initial_tempo ;
  
  unsigned char panning_separation ;
  /* range from 0 to 128, 128 : max separation */
  
  unsigned char channels_volumes [64] ;
  /* range from 0 to 64 */

  unsigned char channels_pannings [64] ;
  /* range from 0 (left) to 64 (right)
     32 : central pannings
     100 : Surround */

  unsigned char *orders ;
  
  p_instrument instruments[256] ;

  p_sample samples[256] ;

  p_pattern patterns[256] ;

} module, *p_module ;


#endif /*__types_h__*/


/***********/
/* types.h */
/***********/

