/* player.c */
/*
     PLAY_ITW.EXE v0.02b : Player for Impulse Tracker modules files
     Copyright (C) 1997  Olivier AUMAGE
     E-mail : Olivier.Aumage@ens-lyon.fr
     Web : http://www.ens-lyon.fr/~oaumage/

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* main header files */
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <math.h>

/* project header files */
#include "types.h"
#include "buffer.h"
#include "win32drv.h"
#include "loader.h"
#include "mix_fi0.h"
#include "mix_fi1.h"
#include "mix_fi2.h"
#include "mix_fi3.h"
#include "mix_fr0.h"
#include "mix_fr1.h"
#include "mix_fr2.h"
#include "mix_fr3.h"
#include "mixcmd.h"
#include "player.h"


void fft(p_complex data, long size, int ifft)
{
  int sign ;
  long m, irem, l, le, le1, k, ip, i, j ;
  double ur, ui, wr, wi, tr, ti, temp ;

  j = 1 ;
  for (i = 1 ; i < size ; i++)
  {
    if (i < j)
    {
      tr = data[j - 1].real ;
      ti = data[j - 1].imag ;
      data[j - 1].real = data[i - 1].real ;
      data[j - 1].imag = data[i - 1].imag ;
      data[i - 1].real = tr ;
      data[i - 1].imag = ti ;
    }

    k = size >> 1 ;
    while (k < j)
    {
      j -= k ;
      k >>= 1 ;
    }

    j += k ;
  }
  printf ("\n") ;
  m = 0 ;
  irem = size ;

  while (irem > 1)
  {
    irem >>= 1 ;
    m++ ;
  }
  if (ifft == 1)
  {
    sign = 1 ;
  }
  else
  {
    sign = -1 ;
  }

  for (l = 1 ; l <= m ; l++)
  {
    le = 1L << l ;
    le1 = le >> 1 ;

    ur = 1.0 ;
    ui = 0 ;

    wr = cos (3.141592653589/le1) ;
    wi = sign * sin (3.141592653589/le1) ;

    for (j = 1 ; j <= le1 ; j++)
    {
      i = j ;
      while (i <= size)
      {
        ip = i + le1 ;

        tr = data[ip - 1].real * ur - data[ip - 1].imag * ui ;
        ti = data[ip - 1].imag * ur + data[ip - 1].real * ui ;

        data[ip - 1].real = data[i - 1].real - tr ;
        data[ip - 1].imag = data[i - 1].imag - ti ;
        data[i - 1].real = data[i - 1].real + tr ;
        data[i - 1].imag = data[i - 1].imag + ti ;

        i = i + le ;
      }

      temp = ur * wr - ui * wi ;
      ui = ui * wr + ur * wi ;
      ur = temp ;
    }
  }
  if (ifft == 1)
  {
    for (i = 0 ; i < size ; i++)
    {
      data[i].real /= size ;
      data[i].imag /= size ;
    }
  }
}

static void *memalloc (size_t size)
/* Allocate 'size' bytes of memory by calling 'malloc'.
   If the allocation fail, a message is printed on the
   'stderr' stream and the program exit. */
{
  /* local variables of 'memalloc' */
  /*_______________________________*/

  void *return_value ;
  

  /* 'memalloc' body */
  /*_________________*/

  return_value = (void *)GlobalAlloc (GMEM_FIXED, (DWORD)size) ;
  if (return_value == (void *) NULL)
    {
      (void) fprintf (stderr, "Memory allocation of %ld bytes failed.\nExiting\n", (long) size) ;
      exit (1) ;
    }
  return return_value ;
}

void error (char *error_message)
{
  fprintf (stderr, "Error : %s\n", error_message) ;
  exit (EXIT_FAILURE) ;
}


void main (int argc, char *argv[])
{
  module IT_module ;
  int filter_on_off ;
  int surround_on_off ;
  int new_note_action ;
  unsigned char number_of_buffers ;
  unsigned short sampling_rate = 44100U ;
  unsigned char priority_boost ;
  unsigned short number_of_virtual_channels ;
  signed short panning_separation ;
  double mixing_volume ;
  unsigned short volume_ramp_length ;
  int volume_ramp_on_off ;
  int loop_allowed ;
  char *file_name ;

  loop_allowed = 0 ;
  volume_ramp_length = 256 ;
  volume_ramp_on_off = 1 ;
  number_of_virtual_channels = 256 ;
  mixing_volume = -1 ;
  panning_separation = -1 ;
  priority_boost = 3 ;
  filter_on_off = 0 ;
  surround_on_off = 0 ;
  new_note_action = 1 ;
  number_of_buffers = 8 ;
  feedback_volume = 128.0  ;
  feedback_delay = 8 ;
  file_name = (char *)NULL ;
  oversampling = 1 ; /* no oversampling */

  while ((--argc) > 0)
  {
    if (!strcmp (argv[argc], "-h"))
    {
      printf ("Play_ITw v0.02b : Player for Impulse Tracker files\n") ;
      printf ("For Microsoft  Windows 95\n") ;
      printf ("| Copyright (C) 1997  Olivier AUMAGE\n");
      printf ("| E-mail : Olivier.Aumage@ens-lyon.fr\n");
      printf ("| Web : http://www.ens-lyon.fr/~oaumage/\n") ;
      printf ("| Usage : play_itw.exe [<IT_file>.IT [options] | [-h]\n") ;
      printf ("\n\t<IT_file>.IT  : Impulse Tracker module file\n") ;
      printf ("\n  options :\n") ;
      printf ("\t-B:<buffers>    : number of buffers\n") ;
      printf ("\t-V:<channels>   : number of virtual channels\n") ;
      printf ("\t-M:<value>      : Mixing volume\n") ;
      printf ("\t-S:<value>      : Panning separation\n") ;
      printf ("\t-R:<value>      : 1 = 11kHz, 2 = 22kHz, 4 = 44kHz.\n") ;
      printf ("\t-p              : priority boost OFF\n");
      printf ("\t+p              : priority boost ON\n");
      printf ("\t*p              : HIGH priority boost ON\n");
      printf ("\t-f              : Digital filter OFF\n") ;
      printf ("\t+f              : Digital filter ON\n") ;
      printf ("\t-s              : Surround OFF\n") ;
      printf ("\t+s              : Surround ON\n") ;
      printf ("\t-n              : NNAs OFF\n") ;
      printf ("\t+n              : NNAs ON (default)\n") ;
      printf ("\t-l              : Play in loop : NO (default)\n") ;
      printf ("\t+l              : Play in loop : YES\n") ;
      printf ("\t-v              : Volume ramps OFF\n") ;
      printf ("\t+v              : Volume ramps ON (default)\n") ;
      printf ("\t-L:<value>      : Volume ramps length\n");
      printf ("\t-O:<value>      : Oversampling\n") ;
      printf ("\t-FV:<value>     : Feedback Volume\n") ;
      printf ("\t-FD:<value>     : Feedback Delay\n") ;
      printf ("\n") ;
      printf ("\t-h  : print this message\n") ;
      exit (EXIT_SUCCESS) ;
    }
    else if (!strncmp (argv[argc], "-B:", 3))
    {
      number_of_buffers = atoi (argv[argc] + 3) ;
    }
    else if (!strncmp (argv[argc], "+B:", 3))
    {
      number_of_buffers = atoi (argv[argc] + 3) ;
    }
    else if (!strncmp (argv[argc], "-V:", 3))
    {
      number_of_virtual_channels = atoi (argv[argc] + 3) ;
    }
    else if (!strncmp (argv[argc], "+V:", 3))
    {
      number_of_virtual_channels = atoi (argv[argc] + 3) ;
    }
    else if (!strncmp (argv[argc], "-M:", 3))
    {
      mixing_volume = atoi (argv[argc] + 3) ;
    }
    else if (!strncmp (argv[argc], "+M:", 3))
    {
      mixing_volume = atoi (argv[argc] + 3) ;
    }
    else if (!strncmp (argv[argc], "-L:", 3))
    {
      int value ;
      value = atoi (argv[argc] + 3) ;
      value += 5 ;
      if (value > 12)
      {
        value = 12 ;
      }
      volume_ramp_length = 1U << value ;
    }
    else if (!strncmp (argv[argc], "+L:", 3))
    {
      int value ;
      value = atoi (argv[argc] + 3) ;
      value += 5 ;
      if (value > 12)
      {
        value = 12 ;
      }
      volume_ramp_length = 1U << value ;
    }
    else if (!strncmp (argv[argc], "-S:", 3))
    {
      panning_separation = atoi (argv[argc] + 3) ;
    }
    else if (!strncmp (argv[argc], "+S:", 3))
    {
      panning_separation = atoi (argv[argc] + 3) ;
    }
    else if (!strncmp (argv[argc], "-R:", 3))
    {
      int value ;
      value = atoi (argv[argc] + 3) ;
      if (value == 1)
      {
        sampling_rate = 11025 ;
      }
      else if (value == 2)
      {
        sampling_rate = 22050 ;
      }
      else if (value == 4)
      {
        sampling_rate = 44100 ;
      }
    }
    else if (!strncmp (argv[argc], "+R:", 3))
    {
      int value ;
      value = atoi (argv[argc] + 3) ;
      if (value == 1)
      {
        sampling_rate = 11025 ;
      }
      else if (value == 2)
      {
        sampling_rate = 22050 ;
      }
      else if (value == 4)
      {
        sampling_rate = 44100 ;
      }
    }
    else if (!strncmp (argv[argc], "-FV:", 4))
    {
      feedback_volume = atoi (argv[argc] + 4) ;
    }
    else if (!strncmp (argv[argc], "+FV:", 4))
    {
      feedback_volume = atoi (argv[argc] + 4) ;
    }
    else if (!strncmp (argv[argc], "-FD:", 4))
    {
      feedback_delay = atoi (argv[argc] + 4) ;
    }
    else if (!strncmp (argv[argc], "+FD:", 4))
    {
      feedback_delay = atoi (argv[argc] + 4) ;
    }
    else if (!strncmp (argv[argc], "-O:", 3))
    {
      oversampling = atoi (argv[argc] + 3) ;
      if (oversampling == 0)
      {
        oversampling = 1 ;
      }
    }
    else if (!strncmp (argv[argc], "+O:", 3))
    {
      oversampling = atoi (argv[argc] + 3) ;
      if (oversampling == 0)
      {
        oversampling = 1 ;
      }
    }
    else if (!strcmp (argv[argc], "-p"))
    {
      priority_boost = 0 ;
    }
    else if (!strcmp (argv[argc], "+p"))
    {
      priority_boost = 1 ;
    }
    else if (!strcmp (argv[argc], "*p"))
    {
      priority_boost = 2 ;
    }
    else if (!strcmp (argv[argc], "-f"))
    {
      filter_on_off = 0 ;
    }
    else if (!strcmp (argv[argc], "+f"))
    {
      filter_on_off = 1 ;
    }
    else if (!strcmp (argv[argc], "-s"))
    {
      surround_on_off = 0 ;
    }
    else if (!strcmp (argv[argc], "+s"))
    {
      surround_on_off = 1 ;
    }
    else if (!strcmp (argv[argc], "-n"))
    {
      new_note_action = 0 ;
    }
    else if (!strcmp (argv[argc], "+n"))
    {
      new_note_action = 1 ;
    }
    else if (!strcmp (argv[argc], "-l"))
    {
      loop_allowed = 0 ;
    }
    else if (!strcmp (argv[argc], "+l"))
    {
      loop_allowed = 1 ;
    }
    else if (!strcmp (argv[argc], "-v"))
    {
      volume_ramp_on_off = 0 ;
    }
    else if (!strcmp (argv[argc], "+v"))
    {
      volume_ramp_on_off = 1 ;
    }
    else if (file_name == NULL)
    {
      file_name = argv[argc] ;
    }
    else
    {
      printf ("Usage : play_itw.exe [<IT_file>.IT [[-|+|*]p|[-|+]f|[-|+]s|[-|+]n|]] | [-h]\n") ;
      exit (EXIT_FAILURE) ;
    }
  }

  if (file_name == (char *) NULL)
  {
    printf ("Usage : play_itw.exe [<IT_file>.IT [[-|+|*]p|[-|+]f|[-|+]s|[-|+]n|]] | [-h]\n") ;
    exit (EXIT_FAILURE) ;
  }

  printf ("Play_ITw v0.02b : Player for Impulse Tracker files\n") ;
  printf ("Copyright (C) 1997  Olivier AUMAGE\n") ;
  printf ("  This program is free software; you can redistribute it and/or modify\n") ;
  printf ("  it under the terms of the GNU General Public License as published by\n") ;
  printf ("  the Free Software Foundation; either version 2 of the License, or\n") ;
  printf ("  any later version.\n") ;
  printf ("DISCLAIMER:\n") ;
  printf ("  This program is distributed in the hope that it will be useful,\n") ;
  printf ("  but WITHOUT ANY WARRANTY; without even the implied warranty of\n") ;
  printf ("  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n") ;
  printf ("  GNU General Public License for more details.\n\n") ;

  /* init part */
  mixing_buffer_length = 0x10000LU ;
  end_of_song = 0 ;

  if (feedback_volume > 256)
  {
    feedback_volume = 256 ;
  }
  feedback_volume /= 128.0 ;

  if (feedback_delay > 255)
  {
    feedback_delay = 255 ;
  }
  feedback_delay *= 32 ;
  feedback_delay *= oversampling ;
  feedback_delay /= (44100 / sampling_rate) ;

  if (filter_on_off == 1)
  {
    unsigned short i ;

    if (surround_on_off == 1)
    {
      unsigned long counter ;

      double_mixer_buffer = (double*) memalloc ((size_t)(16*(oversampling*mixing_buffer_length + oversampling*32L + feedback_delay))) ;

      for (counter = oversampling*mixing_buffer_length ; counter < (oversampling*mixing_buffer_length + feedback_delay) ; counter++)
      {
        double_mixer_buffer[((counter + oversampling*31L) << 1)] = 0.0 ;
        double_mixer_buffer[((counter + oversampling*31L) << 1) + 1] = 0.0 ;
      }
    }
    else
    {
      double_mixer_buffer = (double*) memalloc ((size_t)(16*(oversampling*mixing_buffer_length + oversampling*32))) ;
    }

    {
      unsigned long counter ;

      for (counter = 0 ; counter < (oversampling*mixing_buffer_length + oversampling*32L) ; counter++)
      {
        double_mixer_buffer[(counter << 1)] = 0.0 ;
        double_mixer_buffer[(counter << 1) + 1] = 0.0 ;
      }
    }

    for (i = 0 ; i < 32 ; i ++)
    {
      double_mixer_buffer[(i << 1)] = 0.0 ;
      double_mixer_buffer[(i << 1) + 1] = 0.0 ;
      if (i < 16)
      {
        filter[i].real = sqrt(16.0 - i)/4.0 + 1;
      }
      else if (i < 24)
      {
        filter[i].real = (sqrt(i - 16.0 )/4.0 + 1);
      }
      else
      {
        filter[i].real = 0 ;
      }
    }

    fft (filter, 32, 1) ; /* calculate the IFFT of the filter */
    for (i = 0 ; i < 16 ; i++)
    {
      double temp_r ;
      double temp_i ;

      temp_r = filter[i].real ;
      temp_i = filter[i].imag ;
      filter[i].real = filter[31 - i].real ;
      filter[i].imag = filter[31 - i].imag ;

      filter[31 - i].real = temp_r ;
      filter[31 - i].imag = temp_i ;
    }
  }
  else
  {
    if (surround_on_off == 1)
    {
      double_mixer_buffer = (double*) memalloc ((size_t)(16*(oversampling*mixing_buffer_length + feedback_delay))) ;
      {
        unsigned long counter ;

        for (counter = oversampling*mixing_buffer_length ; counter < (oversampling*mixing_buffer_length + feedback_delay) ; counter++)
        {
          double_mixer_buffer[(counter << 1)] = 0.0 ;
          double_mixer_buffer[(counter << 1) + 1] = 0.0 ;
        }
      }
    }
    else
    {
/*      double_mixer_buffer = (double*) memalloc ((size_t)(4*16*mixing_buffer_length)) ;*/
      double_mixer_buffer = (double*) memalloc ((size_t)(16L*oversampling*mixing_buffer_length)) ;
    }
  }

  /* loading part */
  /*  printf ("Loading module\n") ;*/
  if (load_module (file_name, (p_module)(&IT_module)))
  {
    error ("File not loaded") ;
  }

  printf ("\tModule : %s\n", IT_module.name) ;
  init_mixer ();
  printf ("\tSampling rate : %d Hz\n", sampling_rate) ;

  if (new_note_action)
  {
    printf ("\tNNAs on\n") ;
  }
  else
  {
    printf ("\tNNAs off\n") ;
  }

  if (number_of_buffers < 2)
  {
    number_of_buffers = 2 ;
  }

  if (priority_boost == 3) /* no priority boost command */
  {
    priority_boost = 0 ;
    if (new_note_action > 0)
    {
      priority_boost++ ;
    }
    if ((filter_on_off)||(surround_on_off))
    {
      priority_boost = 2 ;
    }
    /* allocate more time resource for NNAs and for filter */
  }

  if (oversampling > 1)
  {
    printf ("\tOversampling x%d\n", oversampling) ;
  }
  if (priority_boost == 2)
  {
    printf ("\tHIGH Priority Boost on\n") ;
  }
  else if (priority_boost == 1)
  {
    printf ("\tPriority Boost on\n") ;
  }
  else
  {
    printf ("\tPriority Boost off\n") ;
  }

  if (mixing_volume < 0)
  {
    mixing_volume = IT_module.mixing_volume ; /* / 3.0 ; */
  }
  else
  {
    if (mixing_volume > 1024)
    {
      mixing_volume = 1024 ;
    }
/*    mixing_volume /= 3.0 ;*/
  }

  printf ("\tMixing volume : %d/128\n", (int)(mixing_volume)) ;

  if (panning_separation == -1)
  {
    panning_separation = IT_module.panning_separation ;
  }
  else
  {
    if (panning_separation > 128)
    {
      panning_separation = 128 ;
    }
    IT_module.panning_separation = (unsigned char)panning_separation ;
  }

  printf ("\tPanning separation : %d/128\n", (int)panning_separation) ;

  if (volume_ramp_on_off)
  {
    printf ("\tVolume ramps on. Ramps length : %d\n", volume_ramp_length) ;
  }

  if (filter_on_off == 1)
  {
    printf ("\tFilter On\n") ;
    if (surround_on_off)
    {
      printf ("\tSurround On, Volume : %03.0lf/256, Delay : %03lu/255\n", feedback_volume*128.0, feedback_delay/32*(44100 / sampling_rate)) ;
      if (volume_ramp_on_off)
      {
        win32drv_init (sampling_rate, number_of_buffers, priority_boost, fill_mixing_buffer_interpolation_float_volume_ramp_3) ;
      }
      else
      {
        win32drv_init (sampling_rate, number_of_buffers, priority_boost, fill_mixing_buffer_interpolation_float_3) ;
      }
    }
    else
    {
      printf ("\tSurround Off\n") ;
      if (volume_ramp_on_off)
      {
        win32drv_init (sampling_rate, number_of_buffers, priority_boost, fill_mixing_buffer_interpolation_float_volume_ramp_1) ;
      }
      else
      {
        win32drv_init (sampling_rate, number_of_buffers, priority_boost, fill_mixing_buffer_interpolation_float_1) ;
      }
    }
  }
  else
  {
    printf ("\tFilter Off\n") ;
    if (surround_on_off)
    {
      printf ("\tSurround On, Volume : %03.0lf/256, Delay : %03lu/255\n", feedback_volume*128.0, feedback_delay/32*(44100 / sampling_rate)) ;
      if (volume_ramp_on_off)
      {
        win32drv_init (sampling_rate, number_of_buffers, priority_boost, fill_mixing_buffer_interpolation_float_volume_ramp_2) ;
      }
      else
      {
        win32drv_init (sampling_rate, number_of_buffers, priority_boost, fill_mixing_buffer_interpolation_float_2) ;
      }
    }
    else
    {
      printf ("\tSurround Off\n") ;
      if (volume_ramp_on_off)
      {
        win32drv_init (sampling_rate, number_of_buffers, priority_boost, fill_mixing_buffer_interpolation_float_volume_ramp_0) ;
      }
      else
      {
        win32drv_init (sampling_rate, number_of_buffers, priority_boost, fill_mixing_buffer_interpolation_float_0) ;
      }
    }
  }

  if (number_of_virtual_channels > 256)
  {
    number_of_virtual_channels = 256 ;
  }
  printf ("\tVirtual channels : %d\n", number_of_virtual_channels) ;
  init_mixing_variables (&IT_module, sampling_rate, new_note_action, number_of_virtual_channels, mixing_volume, volume_ramp_on_off, volume_ramp_length * oversampling * sampling_rate / 44100, loop_allowed) ;
  win32drv_start() ;
  while ((!kbhit()) && (end_of_song < 2))
  {
  }
  win32drv_stop () ;
  printf ("\nBye !...\n") ;
}
