/* mixtypes.h */
/*
     PLAY_ITW.EXE v0.02b : Player for Impulse Tracker modules files
     Copyright (C) 1997  Olivier AUMAGE
     E-mail : Olivier.Aumage@ens-lyon.fr
     Web : http://www.ens-lyon.fr/~oaumage/

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __MIXTYPES_H_
#define __MIXTYPES_H_
#include "types.h"

/* data structures */
typedef struct s_virtual_channel
{
  /* these fields describe the status of the channel */
  unsigned char channel_playing ; /* 1 = channel playing, 0 = channel not playing anymore */
  unsigned char channel_in_background ; /* 1 = channel is a real channel, 0 = channel is a virtual channel */
  unsigned char corresponding_real_channel ; /* 0 -> 63 */

  /* these fields describe the datas of the channel */
  unsigned char instrument_of_channel ;
  unsigned char sample_of_channel ;

  p_instrument pointer_on_instrument ;
  p_sample pointer_on_sample ;

  unsigned char sustain ;
  unsigned char fade ;

  double final_volume_left ;
  double final_volume_right ;
  double last_final_volume_left ;
  double last_final_volume_right ;
  double last_final_feedback_volume_left ;
  double last_final_feedback_volume_right ;

  double delta_volume_left ;
  double delta_volume_right ;
  double delta_feedback_volume_left ;
  double delta_feedback_volume_right ;
  double last_sound_value ;
  int use_last_sound_value ;
  int use_ramp_down ;

  int new_sample ;
  int end_of_sample ;

  unsigned short ramp_position ;

  unsigned short volume ;

  unsigned short volume_of_instrument ;
  unsigned char panning_of_instrument ;

  unsigned short volume_of_sample ;

  unsigned short volume_of_channel ;
  signed char panning_of_channel ;

  unsigned short note_fade_component ;

  /* these fields concern the envelopes */
  p_envelope volume_envelope ;
  unsigned short volume_envelope_tick ;
  unsigned char  volume_envelope_value ;
  unsigned char  end_of_volume_envelope ;
  unsigned char *interpolated_volume_envelope ;

  p_envelope panning_envelope ;
  unsigned short panning_envelope_tick ;
  unsigned char  end_of_panning_envelope ;
  signed char *interpolated_panning_envelope ;

  /* these fields show the mixing state of the channel */
  double *pointer_in_sample_of_channel ;
  unsigned long frac_position_in_sample_of_channel ;
  unsigned long step_length_for_sample_of_channel ;
  unsigned long note_table_value ;
  double *pointer_on_sample_beginning ;
  double *pointer_on_sample_end ;

  double *pointer_on_loop_beginning ;
  double *pointer_on_loop_end ;
  unsigned char use_loop ;
  unsigned char use_ping_pong_loop ;

  double *pointer_on_sustain_loop_beginning ;
  double *pointer_on_sustain_loop_end ;
  unsigned char use_sustain_loop ;
  unsigned char use_ping_pong_sustain_loop ;

  signed char direction ;
} virtual_channel, *p_virtual_channel ;

typedef struct s_real_channel
{
  unsigned char playing ;
  /*
     1 = channel playing : the virtual channel associated is allocated, it can be used
                           for a new note if new-note-action is 'cut note'
     0 = channel not playing : the virtual_channel associated has been desallocated
                               -> a new one must be allocated to play a note
                               in this case 'foreground_virtual_channel_number' must
                               be considered as invalid
  */

  unsigned char previous_mask_variable ;
  unsigned char previous_note_value ;
  unsigned char previous_instrument ;
  unsigned char previous_volume_panning ;
  unsigned char previous_command ;
  unsigned char previous_command_value ;
  unsigned char effect_update ;

  unsigned char last_slide_parameter ;
  unsigned char last_channel_volume_slide_parameter ;
  unsigned char last_panning_slide_parameter ;
  unsigned char slide_value ;

  unsigned char last_slide_to_note_note ;
  unsigned char last_slide_to_note_speed ;
  signed char slide_to_note_direction ;

  unsigned char last_instrument_used ;
  unsigned char last_sample_used ;
  unsigned char last_note_used ;
  unsigned char last_sample_note_used ;
  unsigned char last_sub_note_used ;

  unsigned char current_new_note_action ;
  unsigned char current_duplicate_check_type ;
  unsigned char current_duplicate_check_action ;

  unsigned short volume_of_channel ;
  signed char panning_of_channel ;

  int muted_channel ;
  
  unsigned char foreground_virtual_channel_number ;
  p_virtual_channel foreground_virtual_channel ;

} real_channel, *p_real_channel ;

#endif

