/* mix_fi1.c */
/*
     PLAY_ITW.EXE v0.02b : Player for Impulse Tracker modules files
     Copyright (C) 1997  Olivier AUMAGE
     E-mail : Olivier.Aumage@ens-lyon.fr
     Web : http://www.ens-lyon.fr/~oaumage/

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* project header files */
#include "types.h"
#include "mix_fi2.h"
#include "mixtypes.h"
#include "mixvars.h"
#include "mixcmd.h"
#include "buffer.h"


void fill_mixing_buffer_interpolation_float_1 (void)
{
  unsigned char channel_counter ;
  unsigned long sample_counter ;
  unsigned long beginning_of_sample_counter ;
  unsigned long end_of_sample_counter ;
  unsigned char new_frame_requested ;
  double *local_mixer_buffer ;
  unsigned long local_mixing_buffer_length ;

  local_mixing_buffer_length = mixing_buffer_length * oversampling ;
  local_mixer_buffer = double_mixer_buffer + 31 * 2 * oversampling ;

#define clear_buffer \
   local_mixer_buffer[sample_counter << 1] = 0.0 ;\
   local_mixer_buffer[((sample_counter++) << 1) + 1] = 0.0 ;

  /* clear the mixing buffer */
  for (sample_counter = 0 ; sample_counter < local_mixing_buffer_length ; )
  {
    clear_buffer clear_buffer clear_buffer clear_buffer
    clear_buffer clear_buffer clear_buffer clear_buffer
    clear_buffer clear_buffer clear_buffer clear_buffer
    clear_buffer clear_buffer clear_buffer clear_buffer
  }

  /* init sample_counter */
  end_of_sample_counter = 0 ;

  /* mixing loop */
  while (end_of_sample_counter < local_mixing_buffer_length)
  {
    beginning_of_sample_counter = end_of_sample_counter ;


    if ((samples_per_frame*oversampling - current_sample) <= (local_mixing_buffer_length - beginning_of_sample_counter))
    {
      end_of_sample_counter = beginning_of_sample_counter + (samples_per_frame*oversampling - current_sample) ;
      current_sample = samples_per_frame*oversampling ;
      new_frame_requested = 1 ;
    }
    else
    {
      end_of_sample_counter = local_mixing_buffer_length ;
      current_sample += local_mixing_buffer_length - beginning_of_sample_counter ;
      new_frame_requested = 0 ;
    }

    /* channels loop */
    for (channel_counter = 0 ; channel_counter < number_of_virtual_channels_allocated ; channel_counter++ )
    {
      p_virtual_channel current_virtual_channel ;
      double interpolation ;
      unsigned char channel_dropped ;
      double *pointer_in_sample_of_channel ;
      unsigned long frac_position_in_sample_of_channel ;
      unsigned long step_length_for_sample_of_channel ;
      signed char direction ;
      double final_volume_left ;
      double final_volume_right ;

      channel_dropped = 0 ;

      current_virtual_channel = virtual_channels[channel_counter] ;

      pointer_in_sample_of_channel = current_virtual_channel->pointer_in_sample_of_channel ;
      frac_position_in_sample_of_channel = current_virtual_channel->frac_position_in_sample_of_channel ;
      step_length_for_sample_of_channel = current_virtual_channel->step_length_for_sample_of_channel / oversampling ;
      direction = current_virtual_channel->direction ;
      final_volume_left = 64.0 * current_virtual_channel->final_volume_left * global_volume * (double)mixing_volume / (17179869184.0 * 1048576.0 * 1048576.0) / oversampling; /* 2^74*/
      final_volume_right = 64.0 * current_virtual_channel->final_volume_right * global_volume * (double)mixing_volume / (17179869184.0 * 1048576.0 * 1048576.0) / oversampling ;

      if (
                   (current_virtual_channel->use_loop)
                || ((current_virtual_channel->sustain)&&(current_virtual_channel->use_sustain_loop))
              )
/* normal loop */
      {
        double *loop_beginning ;
        double *loop_end ;
        int ping_pong ;

        if ((current_virtual_channel->sustain)&&(current_virtual_channel->use_sustain_loop))
        {
          loop_beginning = current_virtual_channel->pointer_on_sustain_loop_beginning ;
          loop_end = current_virtual_channel->pointer_on_sustain_loop_end ;
          ping_pong = current_virtual_channel->use_ping_pong_sustain_loop ;
        }
        else
        {
          loop_beginning = current_virtual_channel->pointer_on_loop_beginning ;
          loop_end = current_virtual_channel->pointer_on_loop_end ;
          ping_pong = current_virtual_channel->use_ping_pong_loop ;
        }

        if (ping_pong)
        { /* ping pong loop */

/* unrolled loop part definition */
#define unrolled_ping_pong_loop                                                                                                                             \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                                                                                  \
    ((*pointer_in_sample_of_channel)  * 16384)\
   + (                                                                                                                                               \
      (                                                                                                                                              \
         (                                                                                                                                           \
            (*(pointer_in_sample_of_channel + direction))\
          - (*pointer_in_sample_of_channel)\
         )                                                                                                                                           \
       * frac_position_in_sample_of_channel\
      )                                                                                                                                         \
     )                                                                                                                                               \
  )  ;                                                                                                                                               \
  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel +=                                                                                                                    \
  (                                                                                                                                                  \
   direction                                                                                                                                         \
   *                                                                                                                                                 \
   (                                                                                                                                                 \
    (                                                                                                                                                \
     frac_position_in_sample_of_channel += step_length_for_sample_of_channel                                                                         \
    ) >> 14                                                                                                                                          \
   )                                                                                                                                                 \
  ) ;                                                                                                                                                \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
  if (                                                                                                                                           \
      (direction == -1)                                                                                                                          \
      &&                                                                                                                                         \
      (  pointer_in_sample_of_channel                                                                                                            \
         <= loop_beginning                                                                                   \
      )                                                                                                                                          \
     )                                                                                                                                           \
  {                                                                                                                                              \
    direction = 1 ;                                                                                                                              \
    pointer_in_sample_of_channel = loop_beginning ;                                                          \
    frac_position_in_sample_of_channel = 0LU ;                                                                                                   \
  }                                                                                                                                              \
  else if (                                                                                                                                      \
            (direction == 1)                                                                                                                     \
            &&                                                                                                                                   \
            (   pointer_in_sample_of_channel                                                                                                     \
             >= loop_end                                                                                     \
            )                                                                                                                                    \
          )                                                                                                                                      \
  {                                                                                                                                              \
    direction = -1 ;                                                                                                                             \
    pointer_in_sample_of_channel = loop_end ;                                                                \
    frac_position_in_sample_of_channel = 0LU ;                                                                                                   \
  }                                                                                                                                              \
}

#define unrolled_ping_pong_loop_forward                                                                                                                             \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                                                                                  \
    ((*pointer_in_sample_of_channel) * 16384)\
   + (                                                                                                                                               \
      (                                                                                                                                              \
         (                                                                                                                                           \
            (*(pointer_in_sample_of_channel + 1))\
          - (*pointer_in_sample_of_channel)\
         )                                                                                                                                           \
       * frac_position_in_sample_of_channel\
      )\
     )                                                                                                                                               \
  )  ;                                                                                                                                               \
  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel += (frac_position_in_sample_of_channel += step_length_for_sample_of_channel) >> 14 ; \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
  if (pointer_in_sample_of_channel >= loop_end)                                                                                                                                      \
  {                                                                                                                                              \
    direction = -1 ;                                                                                                                             \
    pointer_in_sample_of_channel = loop_end ; \
    frac_position_in_sample_of_channel = 0LU ; \
    continue ; \
  } \
}

#define unrolled_ping_pong_loop_reverse                                                                                                                             \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                                                                                  \
    ((*pointer_in_sample_of_channel) * 16384)\
   + (                                                                                                                                               \
      (                                                                                                                                              \
         (                                                                                                                                           \
            (*(pointer_in_sample_of_channel - 1))\
          - (*pointer_in_sample_of_channel)\
         )                                                \
       * frac_position_in_sample_of_channel\
      )\
     )                                                                                                                                               \
  )  ;  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel -= (frac_position_in_sample_of_channel += step_length_for_sample_of_channel) >> 14 ; \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
  if (pointer_in_sample_of_channel<= loop_beginning)                                                                                                                                           \
  {                                                                                                                                              \
    direction = 1 ;                                                                                                                              \
    pointer_in_sample_of_channel = loop_beginning ;                                                          \
    frac_position_in_sample_of_channel = 0LU ;                                                                                                   \
    continue ; \
  }                                                                                                                                              \
}

#define unrolled_ping_pong_loop_forward_optimized                                                                                                                             \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                                                                                  \
    ((*pointer_in_sample_of_channel) * 16384)\
   + ( \
      (\
         (\
            (*(pointer_in_sample_of_channel + 1))\
          - (*pointer_in_sample_of_channel)\
         )                                                                                                                                           \
       * frac_position_in_sample_of_channel\
      )\
     )                                                                                                                                               \
  )  ;\
  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel += (frac_position_in_sample_of_channel += step_length_for_sample_of_channel) >> 14 ; \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
}

#define unrolled_ping_pong_loop_reverse_optimized                                                                                                                             \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                                                                                  \
    ((*pointer_in_sample_of_channel) * 16384)\
   + (                                                                                                                                               \
      (                                                                                                                                              \
         (                                                                                                                                           \
            (*(pointer_in_sample_of_channel - 1))\
          - (*pointer_in_sample_of_channel)\
         )                                                                                                                                           \
       * frac_position_in_sample_of_channel\
      )\
     )                                                                                                                                               \
  )  ;                                                                                                                                               \
  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel -= (frac_position_in_sample_of_channel += step_length_for_sample_of_channel) >> 14 ; \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
}

          if (end_of_sample_counter > 15)
          {
            for (sample_counter = beginning_of_sample_counter ; sample_counter < (end_of_sample_counter-15) ; )
            {
              if (direction == 1)
              {
                if ((pointer_in_sample_of_channel + (step_length_for_sample_of_channel >> 10)) < loop_end)
                {
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized

                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized

                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized

                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                  unrolled_ping_pong_loop_forward_optimized
                }
                else
                {
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward

                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward

                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward

                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                  unrolled_ping_pong_loop_forward
                }
              }
              else
              {
                if ((pointer_in_sample_of_channel - (step_length_for_sample_of_channel >> 10)) > loop_beginning)
                {
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized

                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized

                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized

                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                  unrolled_ping_pong_loop_reverse_optimized
                }
                else
                {
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse

                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse

                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse

                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                  unrolled_ping_pong_loop_reverse
                }
              }
            }
          }

          for (; sample_counter < end_of_sample_counter ;)
          {
            unrolled_ping_pong_loop
          }
        }/* end ping_pong loop */
        else /* forward loop */
        {
          double save ;

          save = *loop_end ;
          *loop_end = *loop_beginning ;

/* unrolled loop part definition */
#define unrolled_forward_loop                                                                                                                             \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                         \
    ((*pointer_in_sample_of_channel)  * 16384)\
    +                                                                                       \
    ((                                                                                      \
      (                                                                                     \
       (*(pointer_in_sample_of_channel + 1))                       \
       -                                                                                    \
       (*pointer_in_sample_of_channel)\
      )                                                                                     \
       * frac_position_in_sample_of_channel\
    ))\
  )  ;                                                                                      \
  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel +=                                                                                                                    \
  (                                                                                                                                                  \
   (                                                                                                                                                \
    frac_position_in_sample_of_channel += step_length_for_sample_of_channel                                                                         \
   ) >> 14                                                                                                                                          \
  ) ;                                                                                                                                                \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
  if (   pointer_in_sample_of_channel                                                                                                         \
             >= loop_end                                                                                         \
     )                                                                                                                                        \
  {                                                                                                                                                \
    pointer_in_sample_of_channel = loop_beginning ;                                                            \
    frac_position_in_sample_of_channel = 0LU ;                                                                                                     \
  }                                                                                                                                                \
}

#define unrolled_forward_loop_optimized                                                                                                                             \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                         \
    ((*pointer_in_sample_of_channel) * 16384)\
    +                                                                                       \
    ((                                                                                      \
      (                                                                                     \
       (*(pointer_in_sample_of_channel + 1))\
       -                                                                                    \
       (*pointer_in_sample_of_channel)\
      )                                                                                     \
       * frac_position_in_sample_of_channel\
    ))                                                                                \
  )  ;                                                                                      \
  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel +=                                                                                                                    \
  (                                                                                                                                                  \
   (                                                                                                                                                \
    frac_position_in_sample_of_channel += step_length_for_sample_of_channel                                                                         \
   ) >> 14                                                                                                                                          \
  ) ;                                                                                                                                                \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
}

          if (end_of_sample_counter > 15)
          {
            for (sample_counter = beginning_of_sample_counter ; sample_counter < (end_of_sample_counter-15) ; )
            {
              if ((pointer_in_sample_of_channel + (step_length_for_sample_of_channel >> 10)) < loop_end)
              {
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized

                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized

                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized

                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
                unrolled_forward_loop_optimized
              }
              else
              {
                unrolled_forward_loop
                unrolled_forward_loop
                unrolled_forward_loop
                unrolled_forward_loop

                unrolled_forward_loop
                unrolled_forward_loop
                unrolled_forward_loop
                unrolled_forward_loop

                unrolled_forward_loop
                unrolled_forward_loop
                unrolled_forward_loop
                unrolled_forward_loop

                unrolled_forward_loop
                unrolled_forward_loop
                unrolled_forward_loop
                unrolled_forward_loop
              }
            }
          }

          for (; sample_counter < end_of_sample_counter ;)
          {
            unrolled_forward_loop
          }
          *loop_end = save ;
        }/* end forward loop */
      } /* end normal loop */
      else /* no loop */
      {
        double *pointer_on_sample_end ;

        pointer_on_sample_end = current_virtual_channel->pointer_on_sample_end ;

/* unrolled loop part definition */
#define unrolled_loop                                                                                                                             \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                                                                                  \
    ((*pointer_in_sample_of_channel)  * 16384)\
   + (                                                                                                                                               \
      (                                                                                                                                              \
         (                                                                                                                                           \
            (*(pointer_in_sample_of_channel + 1))\
          - (*pointer_in_sample_of_channel)\
         )                                                                                                                                           \
       * frac_position_in_sample_of_channel\
      )\
     )                                                                                                                                               \
  )  ;                                                                                                                                               \
  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel +=                                                                                                                    \
  (                                                                                                                                                  \
   (                                                                                                                                                \
    frac_position_in_sample_of_channel += step_length_for_sample_of_channel                                                                         \
   ) >> 14                                                                                                                                          \
  ) ;                                                                                                                                                \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
  if (  pointer_in_sample_of_channel                                                                                                               \
      >= current_virtual_channel->pointer_on_sample_end                                                                                             \
     )                                                                                                                                             \
  {                                                                                                                                                \
    current_virtual_channel->channel_playing = 0 ;                                                                                                 \
    if (current_virtual_channel->channel_in_background == 0)                                                                                       \
    {                                                                                                                                              \
      real_channels[current_virtual_channel->corresponding_real_channel].playing = 0 ;                                                             \
    }                                                                                                                                              \
    number_of_virtual_channels_allocated-- ;                                                                                                       \
    {                                                                                                                                              \
      p_virtual_channel temp_virtual_channel ;                                                                                                     \
      temp_virtual_channel = virtual_channels[number_of_virtual_channels_allocated] ;                                                              \
      virtual_channels[number_of_virtual_channels_allocated] = virtual_channels[channel_counter] ;                                                 \
      virtual_channels[channel_counter] = temp_virtual_channel ;                                                                                   \
      real_channels[temp_virtual_channel->corresponding_real_channel].foreground_virtual_channel_number = channel_counter ;                        \
      channel_counter -- ;                                                                                                                         \
      channel_dropped = 1 ;                                                                                                                        \
      break ;                                                                                                                                      \
    }                                                                                                                                              \
  }                                                                                                                                                \
}                                                                                                                                                  \

#define unrolled_loop_optimized  \
{                                                                                                                                                    \
  interpolation = \
  (                                                                                                                                                  \
    ((*pointer_in_sample_of_channel)  * 16384)\
   + (                                                                                                                                               \
      (                                                                                                                                              \
         (                                                                                                                                           \
            (*(pointer_in_sample_of_channel + 1))\
          - (*pointer_in_sample_of_channel)\
         )                                                                                                                                           \
       * frac_position_in_sample_of_channel\
      )\
     )                                                                                                                                               \
  )  ;                                                                                                                                               \
  local_mixer_buffer[((sample_counter) << 1)    ] += final_volume_left * interpolation ;\
  local_mixer_buffer[((sample_counter) << 1) + 1] += final_volume_right* interpolation ;\
  pointer_in_sample_of_channel +=                                                                                                                    \
  (                                                                                                                                                  \
   (                                                                                                                                                \
    frac_position_in_sample_of_channel += step_length_for_sample_of_channel                                                                         \
   ) >> 14                                                                                                                                          \
  ) ;                                                                                                                                                \
  frac_position_in_sample_of_channel &= 0x3FFF ;                                                                                                     \
  sample_counter++ ; \
}                                                                                                                                                  \

        if (end_of_sample_counter > 15)
        {
          for (sample_counter = beginning_of_sample_counter ; sample_counter + 15 < end_of_sample_counter ; )
          {
            if ((pointer_in_sample_of_channel + (step_length_for_sample_of_channel >> 10)) < pointer_on_sample_end)
            {
              unrolled_loop_optimized
              unrolled_loop_optimized
              unrolled_loop_optimized
              unrolled_loop_optimized

              unrolled_loop_optimized
              unrolled_loop_optimized
              unrolled_loop_optimized
              unrolled_loop_optimized

              unrolled_loop_optimized
              unrolled_loop_optimized
              unrolled_loop_optimized
              unrolled_loop_optimized

              unrolled_loop_optimized
              unrolled_loop_optimized
              unrolled_loop_optimized
              unrolled_loop_optimized
            }
            else
            {
              unrolled_loop
              unrolled_loop
              unrolled_loop
              unrolled_loop

              unrolled_loop
              unrolled_loop
              unrolled_loop
              unrolled_loop

              unrolled_loop
              unrolled_loop
              unrolled_loop
              unrolled_loop

              unrolled_loop
              unrolled_loop
              unrolled_loop
              unrolled_loop
            }
          }
        }

        if (channel_dropped)
        {
          continue ;
        }

        for (; sample_counter < end_of_sample_counter ;)
        {
          unrolled_loop
        }
      }/* end no sustain loop */

      if (channel_dropped)
      {
        continue ;
      }
      else
      {
        current_virtual_channel->pointer_in_sample_of_channel = pointer_in_sample_of_channel ;
        current_virtual_channel->frac_position_in_sample_of_channel = frac_position_in_sample_of_channel ;
        current_virtual_channel->direction = direction ;
      }
    } /* end of channel_counter loop */

    if (new_frame_requested)
    {
      if (last_frame)
      {
        end_of_song = 1 ;
        break ;
      }
      else
      {
        current_sample = 0 ;
        new_frame () ;
      }
    }
  } /* end of mixing loop */

#define apply \
for (counter = 0 ; counter < 32 ; counter ++)\
{\
  left += (filter [counter].real) * (double_mixer_buffer[(sample_counter << 1) + ((counter*oversampling) << 1)]) ;\
  right += (filter [counter].real) * (double_mixer_buffer[(sample_counter << 1) + ((counter*oversampling) << 1) + 1]) ;\
}\
if (sample_counter % oversampling == oversampling - 1)\
{\
  if (left > 32767.0)\
  left = 32767.0 ;\
  else if (left < -32767.0)\
  left = -32767 ;\
  if (right > 32767)\
  right = 32767 ;\
  else if (right < -32767)\
  right = -32767 ;\
  mixing_buffer[((sample_counter/oversampling)<< 1)] = (signed short)left ;\
  mixing_buffer[((sample_counter/oversampling)<< 1) + 1] = (signed short)right ;\
  left = 0.0 ; \
  right = 0.0 ;\
}\
sample_counter ++ ;


  {
    double left ;
    double right ;
    unsigned char counter ;

    left = 0.0 ;
    right = 0.0 ;

    for (sample_counter = 0 ; sample_counter < local_mixing_buffer_length ; )
    {
/* 0*/
      apply
      apply
      apply
      apply

      apply
      apply
      apply
      apply

      apply
      apply
      apply
      apply

      apply
      apply
      apply
      apply
/* 16 */
    }
  }

  for (sample_counter = 0 ; sample_counter < 31*oversampling ; sample_counter++)
  {
    double_mixer_buffer[((sample_counter) << 1)] = double_mixer_buffer[((sample_counter + local_mixing_buffer_length) << 1)] ;
    double_mixer_buffer[((sample_counter) << 1) + 1] = double_mixer_buffer[((sample_counter + local_mixing_buffer_length) << 1) + 1] ;
  }
}



