;**************************************************************************
;*	Ce module contient les routines servant  rechercher les
;*	informations sur la musique dans le module CRYS290
;* Programm par Sbastien Granjoux
;* Commenc le 26/12/93
;* Dernire modif 05/01/95


IDEAL
P386N
MODEL SMALL

EXTRN	PEEKMOD:far

PUBLIC	GetMixRate
PUBLIC	GetName
PUBLIC	GetModInf
PUBLIC	GetTempo
PUBLIC	GetPattern
PUBLIC	GetVoice
PUBLIC	GetVoiceByte

INCLUDE "CRYSDEV.INC"
INCLUDE "CRYSLOAD.INC"

EXTRN	Position:far
EXTRN	Line:far
EXTRN	GETMODPOS:far

DATASEG

NoteTab:	DB  0D0h,0C4h,0B9h,0AFh,0A5h,09Bh
		DB  093h,08Bh,083h,07Bh,074h,000h

HIGH_NOTE	EQU	0DCh

CODESEG

;************************************************************************
;*	Renvoit le nom de la musique (28 octets de long) ou d'un instrument
;*	Attention cette fonction marche qu'aprs un LOADMOD et avant
;*	un SETMOD
;*
;* Entre:
;*	BL	numero de l'instrument (0 = nom du module)
;*	ES:DI	buffer o copier le nom musique

PROC	GetName

	push	ds
	mov	ax,SEG Comments
	mov	ds,ax
	ASSUME	ds:SEG Comments
	mov     si,OFFSET Comments
	xor	bh,bh
	shl	bx,5
	add	si,bx

	mov	cx,NAME_LEN
@@next_char:
	lodsb
	or	al,al
	je	@@fill_with_space
	cmp	al,32
	jae	@@no_control
	mov	al,' '
@@no_control:
	stosb
	dec	cx
	jne	@@next_char
@@fill_with_space:
	mov	al,' '
	rep	stosb

	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP

;***************************************************************************
;*	Renvoit le nombre de position totale de la musique
;* Sortie:
;*	AL	nombre de position totale
;*	AH	nombre de voix du mod

PROC	GetModInf


	push	ds
	mov	ax,SEG Sequence
	mov	ds,ax

	ASSUME	ds:SEG Sequence

	mov	ax,[ds:OFFSET LastPos]
	sub	ax,OFFSET Sequence
	shr	ax,1

	mov	ah,[ds:NbVoice]

	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP


;***************************************************************************
;*	Renvoit le tempo dans al et ah
;*
;* Sortie:
;*	AL	tempo normale
;*	AH	tempo tendue

PROC	GetTempo

	push	ds
	mov	ax,SEG Sequence
	mov	ds,ax

	ASSUME	ds:SEG Sequence

	mov	ah,[ds:OFFSET Bpm]
	mov	al,[ds:OFFSET Tempo]

	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP

;***************************************************************************
;*	Renvoit la position dans la squence ainsi que le pattern et la
;*	ligne
;*
;* Sortie:
;*	AH	position dans la squence
;*	AL	pattern
;*	DL	ligne

PROC	GetPattern

	push	ds
	mov	ax,SEG Line
	mov	ds,ax
	ASSUME	ds:SEG Line

	call	GetModPos
	mov	dx,ax
	shl	dx,2
	shr	dl,2

	mov	ax,[word ptr ds:OFFSET Line+2]
	sub	ax,[word ptr ds:OFFSET PatternSeg]
	shr	ax,4
	div	[ds:NbVoice]

	mov	ah,dh
	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP

;*************************************************************************
;*	Donne des informations sur une voix
;*
;* Entre:
;*	BL	numero de la voix
;*
;* Sortie:
;*	CL	note
;*	CH	volume
;*	DL	instrument
;*	DH	effet

PROC	GetVoice

	push	ds

	ASSUME	ds:_DATA
	mov	ax,SEG Voice1
	mov	ds,ax
	ASSUME	ds:SEG Voice1
	mov	al,SIZE VOICE
	mul	bl
	mov	si,ax
	add	si,OFFSET Voice1

	mov	ax,[(VOICE PTR ds:si).note1]
	mov     dl,[(VOICE PTR ds:si).inst]
	mov	dh,[(VOICE PTR ds:si).effnb]
	mov	ch,[(VOICE PTR ds:si).volume]

	pop	ds
	ASSUME  ds:_DATA

	shl	ax,2
	mov	cl,0Ch
	jz	@@find_note
	mov	cl,70h
	cmp	ax,HIGH_NOTE
	jb	@@find_oct
@@next_oct:
	shr	ax,1
	sub	cl,10h
	cmp	ax,HIGH_NOTE
	jae	@@next_oct

@@find_oct:
	mov	si,OFFSET NoteTab
	cmp	al,[ds:si]
	ja	@@find_note
@@next_note:
	inc	si
	inc	cl
	cmp	al,[ds:si]
	jbe	@@next_note
@@find_note:

	ret
ENDP

;*************************************************************************
;*	Retourne l'octet actuellement jou
;*
;* Entre:
;*	BL	numero de la voix
;*
;* Sortie:
;*	AL	octet courant

PROC	GetVoiceByte

	push	bx
	push	bx
	call	far PEEKMOD
	pop	bx
	ret

ENDP

;***************************************************************************
;*	Recupre la frquence de restitution
;*
;* Sortie:
;*	AX	frequence de restitution en Hz

PROC	GetMixRate

	push	ds
	ASSUME	ds:SEG MixRate
	mov	ax,SEG MixRate
	mov	ds,ax
	mov	ax,[ds:OFFSET MixRate]
	pop	ds
	ASSUME	ds:_DATA

	ret

ENDP

ENDS

END
