;****************************************************************************
;*	Module contenant des fonctions DOS de base pour lire un mmoire
;*	ATTENTION toutes ces fonctions sont de type NEAR
;*
;* Programm par Sbastien Granjoux
;* Commenc le 19/02/95
;* Modification le 19/02/95

IDEAL
P386N

INCLUDE "CRYSLOAD.INC"

PUBLIC	USEMEM

SEGMENT CSEG PARA PUBLIC USE16 'CODE'

ASSUME	cs:CSEG

UseMem:
	FILESYS <OFFSET openmem,OFFSET closemem,OFFSET seekmem,OFFSET readmem>

MemPos	DD	0

;***************************************************************************
;*	Ouvre un fichier en mode lecture, ATTENTION il ne peut y avoir
;*	qu'un seul fichier ouvert en mme temps
;*
;* Entre:
;*	DS:DX	position dans la mmoire
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	openmem

	call	normptr
	ret
ENDP

;***************************************************************************
;*	Lit un block d'octet dans un overlay prcdament ouvert
;*
;* Entre:
;*	CX	nombre d'octet  lire
;*	DS:DX	adresse du buffer recevant les donnes
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	readmem

	push	ds
	push	es
	push	si
	push	di
	push	cx
	mov	ax,ds
	mov	es,ax
	mov	di,dx
	lds	si,[cs:MemPos]
	rep	movsb
	mov	dx,si
	call	normptr
	pop	cx
	pop	di
	pop	si
	pop	es
	pop	ds

	ret

ENDP

;***************************************************************************
;*	Se dplace dans l'overlay par rapport  la position courante
;*
;* Entre:
;*      CX:DX	nouvelle position dans l'overlay
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	seekmem

	push	ds
	mov	ch,cl
	xor	cl,cl
	add	dx,[cs:OFFSET MemPos]
	adc	ch,0
	shl	cx,4
	add	cx,[cs:OFFSET MemPos+2]
	mov	ds,cx

	call	normptr
	pop	ds

	ret

ENDP

;***************************************************************************
;*	Ferme la mmoire ouverte prcdament
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	closemem

	ret

ENDP

;**************************************************************************
;*	Normalise un pointeur long et le sauvegarde
;*
;* Entre:
;*	DS:DX	pointeur  normaliser

PROC	normptr

	mov	bx,ds
	mov	ax,dx
	shr	ax,4
	add	bx,ax
	and	dx,000Fh
	mov	[cs:OFFSET MemPos],dx
	mov	[cs:OFFSET MemPos+2],bx

	ret
ENDP

ENDS

END
