                                        ;APS00000000000000000000000000000000000000000000000000000000000000000000000000000000

	LETTERCOUNT=64

	COLOR1=$0449
	COLOR2=$09BE
	COLOR3=$0FFF

	COLOR4=$04A6
	COLOR5=$08FA

	INCDIR	"SOURCES:2013/CRACKTRO/"

	SECTION	ALPHA1,CODE_C

	INCLUDE	"STARTUP.I"

MAIN:	BSR.W	PRECALC
	BSR.W	CALCSTERN
	BSR.W	DL_INIT0
	LEA	$DFF000,A6
	BSR.W	INIT_LETTERS
	BSR.W	INIT_COPPER

	LEA	PLANES,A0		; PUT PLANEPTRS INTO COPPER
	LEA	PL(PC),A1
	MOVEQ	#5-1,D1
DOPL:	MOVE.L	A0,D0
	MOVE.W	D0,6(A1)
	SWAP	D0
	MOVE.W	D0,2(A1)
	ADD.L	#10240,A0
	ADDQ.L	#8,A1
	DBF	D1,DOPL

	LEA	LOGO,A0			; COPY LOGO INTO PLANES
	LEA	PLANES,A1
	MOVE.L	#5*256-1,D0
COPYL1:	MOVE.L	(A0)+,(A1)
	MOVE.L	(A0)+,4(A1)
	ADD.L	#40,A1
	DBF	D0,COPYL1

	LEA	LOGO,A0			; COPY LOGO INTO DOUBLEBUF PLANES
	LEA	PLANE1,A1
	LEA	PLANE2,A2
	LEA	PLANE3,A3
	MOVE.L	#256-1,D0
COPYL2:	MOVE.L	(A0),(A1)
	MOVE.L	(A0),(A2)
	MOVE.L	(A0),(A3)
	MOVE.L	4(A0),4(A1)
	MOVE.L	4(A0),4(A2)
	MOVE.L	4(A0),4(A3)
	MOVE.L	2*2048(A0),10240(A1)
	MOVE.L	2*2048(A0),10240(A2)
	MOVE.L	2*2048(A0),10240(A3)
	MOVE.L	2*2048+4(A0),10244(A1)
	MOVE.L	2*2048+4(A0),10244(A2)
	MOVE.L	2*2048+4(A0),10244(A3)
	ADD.L	#40,A1
	ADD.L	#40,A2
	ADD.L	#40,A3
	ADD.L	#8,A0
	DBF	D0,COPYL2
	
	LEA	MULUTAB(PC),A0		; CREATE MULUTAB
	MOVE.L	#256-1,D0
	MOVEQ	#0,D1
MAKEML:	MOVE.L	D1,(A0)+
	ADD.L	#40,D1
	DBF	D0,MAKEML

	LEA	MOD,A0
	SUB.L	A1,A1
	BSR.W	REPLAY

	LEA	NEWIRQ(PC),A0
	MOVE.L	A0,VBIPTR-NEWIRQ(A0)

	MOVE.L	#COP,$80(A6)

; ==============================================================

MLOOP:	BTST	#6,$BFE001
	BNE.B	MLOOP

; ==============================================================

	BSR.W	REPLAY+8
	RTS

; ==============================================================

NEWIRQ:	MOVEM.L	D0-A6,-(A7)
	BSR.W	DOUBLEBUF
	BSR.W	PROCESSLETTERS
	BSR.W	DRAWLETTER
	BSR.W	DRAWSTERN
	BSR.W	CLEAREFFECT
	BSR.W	REPLAY+4
	MOVEM.L	(A7)+,D0-A6
	RTS

; ==============================================================

CLEAREFFECT:
	TST.B	CLEARSTATUS
	BEQ.W	RAUS	
	SUBQ.W	#1,CLEARDELAY
	BNE.B	RAUS
	MOVE.W	#13,CLEARDELAY
	LEA	PLANES+10240,A1
	ADD.L	CLEARLINE(PC),A1
	MOVEQ	#0,D3
	MOVEQ	#0,D4
	MOVEQ	#0,D5
	MOVEQ	#0,D6
	MOVEQ	#20-1,D7
CLEAR:	MOVE.L	A1,A0
	MOVEM.L	D3-D6,-(A0)
	MOVEM.L	D3-D6,-(A0)
	ADD.L	#9*40,A1
	DBF	D7,CLEAR
	SUB.L	#40,CLEARLINE
	CMP.L	#42*40,CLEARLINE
	BNE.B	RAUS
	MOVE.B	#0,CLEARSTATUS
	MOVE.L	#51*40,CLEARLINE
RAUS:	RTS

; ==============================================================

CALCSTERN:	
	LEA	CALCPOINTS(PC),A1
	MOVE.L	#508,D4			; SINUSADD
CALCS:	LEA	POINTS(PC),A0
	LEA	SINUS(PC),A2		; SIN
	LEA	(A2,D4.W),A2		; +ADDER
	MOVE.W	(A2),D5			; GET SIN
	MOVE.W	64(A2),D6		; GET COS
	MOVEQ	#22-1,D7
CALC:	MOVEM.W	(A0)+,D0/D1
	MOVE.W	D0,D2
	MOVE.W	D1,D3
	MULS.W	D6,D0			; X*COS
	MULS.W	D5,D1			; Y*SIN
	SUB.L	D1,D0
	MULS.W	D5,D2			; X*SIN
	MULS.W	D6,D3			; Y*COS
	ADD.L	D3,D2
	ASR.L	#8,D0
	ASR.L	#8,D2
	ADD.W	#240,D0
	ADD.W	#65,D2
	MOVE.W	D0,(A1)+
	MOVE.W	D2,(A1)+
	DBF	D7,CALC
	CMP.W	#0,D4
	BEQ.B	COUT
	SUBQ.W 	#4,D4
	BRA.B	CALCS
COUT:	RTS
	
; ========================================================

DRAWSTERN:
	LEA	DL_MULUTAB(PC),A2
	MOVE.L	CURPLANES+4(PC),A3
	LEA	CALCPOINTS(PC),A4
	ADD.L	CALCADD(PC),A4
	ADD.L	#10240,A3
	MOVE.L	A3,A5
	BSR.W	DL_INIT
	MOVEQ	#10-1,D7
DRAW:	MOVEM.W	(A4),D0-D3
	MOVE.L	A3,A0
	BSR.W	DRAWLINE	
	ADDQ.L	#4,A4
NOT:	DBF	D7,DRAW
	ADDQ.L	#4,A4
	MOVEQ	#10-1,D7
DRAW2:	MOVEM.W	(A4),D0-D3
	MOVE.L	A3,A0
	BSR.W	DRAWLINE
	ADDQ.L	#4,A4
	DBF	D7,DRAW2

WB:	BTST	#14,$2(A6)
	BNE.B	WB
	ADD.L	#133*40-4,A5
	MOVE.L	A5,$50(A6)
	MOVE.L	A5,$54(A6)
	MOVE.L	#$09F00012,$40(A6)
	MOVE.W	#24,$64(A6)
	MOVE.W	#24,$66(A6)
	MOVE.W	#132*64+8,$58(A6)
	ADD.L	#22*4,CALCADD
	CMP.L	#128*(22*4),CALCADD
	BNE.B	DOUT
	MOVE.L	#0,CALCADD
DOUT:	RTS

; ==============================================================

INIT_COPPER:
	LEA	COPCL(PC),A0
	MOVE.L	#211-1,D2
	MOVE.W	#$2C5F,D0
	MOVE.W	#$2CEF,D1
	BSR.W	INIT_C
	LEA	COPCL2,A0
	MOVE.L	#32-1,D2
	MOVE.W	#$005F,D0
	MOVE.W	#$00EF,D1
	BSR.W	INIT_C
	RTS
INIT_C:	MOVE.W	D0,(A0)+
	MOVE.W	#$FFFE,(A0)+
	MOVE.W	#$0188,(A0)+
	MOVE.W	#COLOR4,(A0)+
	MOVE.W	#$0182,(A0)+
	MOVE.W	#COLOR1,(A0)+
	MOVE.W	#$0184,(A0)+
	MOVE.W	#COLOR2,(A0)+
	MOVE.W	#$0186,(A0)+
	MOVE.W	#COLOR3,(A0)+
	MOVE.W	#$018C,(A0)+
	MOVE.W	#COLOR5,(A0)+
	MOVE.W	D1,(A0)+
	MOVE.W	#$FFFE,(A0)+
	MOVE.L	#$01880005,(A0)+
	MOVE.L	#$01820003,(A0)+
	MOVE.L	#$01840003,(A0)+
	MOVE.L	#$01860004,(A0)+
	MOVE.L	#$018C0017,(A0)+
	ADD.W	#$100,D0
	ADD.W	#$100,D1
	DBF	D2,INIT_C
	RTS

; ==============================================================

DOUBLEBUF:
	LEA	CURPLANES,A3
	MOVEM.L	(A3),A0/A1/A2
	EXG.L	A2,A1
	EXG.L	A1,A0
	MOVEM.L	A0/A1/A2,(A3)

	MOVE.L	A2,D0
	LEA	PL(PC),A3
	MOVE.W	D0,6(A3)
	SWAP	D0
	MOVE.W	D0,2(A3)
	SWAP	D0
	ADD.L	#10240,D0
	MOVE.W	D0,22(A3)
	SWAP	D0
	MOVE.W	D0,18(A3)

WBLT:	BTST	#14,$2(A6)
	BNE.B	WBLT
	ADD.L	#10*40+10,A1
	MOVE.L	A1,$54(A6)
	MOVE.L	#$01000000,$40(A6)
	MOVE.L	#$000A000A,$64(a6)
	MOVE.W	#(256+120)*64+15,$58(A6)

	RTS

; ==============================================================

INIT_LETTERS:
	LEA	LETTERS(PC),A0
	MOVE.L	#LETTERCOUNT-1,D1
	MOVEQ	#0,D0
INIT:	MOVE.B	#1,0(A0)
	MOVE.B	#" ",1(A0)
	MOVE.B	D0,18(A0)		; COUNTER
	MOVE.B	#0,19(A0)		; LAST LETTER STATUS
	ADDQ.B	#2,D0			; INC COUNTER
	CLR.L	20(A0)			; ZOOMTABADD
	ADD.L	#24,A0
	DBF	D1,INIT
	RTS
	
; ==============================================================

PROCESSLETTERS:
	LEA	LETTERS(PC),A0
	LEA	ZOOMTAB(PC),A2
	LEA	BLITTAB+4(PC),A3
	LEA	MULUTAB(PC),A5
	MOVE.L	#LETTERCOUNT-1,D7
NEXTLETTER:
	TST.B	(A0)			; LETTER NEEDS TO BE INITIALIZED
	BEQ.W	INITLETTER		; YO -> INIT LETTER!

	MOVE.B	1(A0),D2		; GET CHAR
	MOVEM.L	2(A0),D0/D1		; GET X AND Y
	SWAP	D0
	SWAP	D1
	MOVE.L	20(A0),D3		; ZOOMTABADD
	MOVE.L	(A2,D3.L),A4		; GET CORRECT ZCHARS-PTR
	MOVE.L	CURPLANES+8(PC),A1	; PTR TO CURRENT PLANE
	BSR.W	BLITCHAR		; PRINT LETTER
	ADDQ.L	#4,20(A0)

	TST.B	18(A0)			; TEST IF ANIM IS FINISHED
	BNE.B	NOTFIN			; NOPE
	CLR.B	(A0)			; OTHERWISE SET INIT STATUS
	TST.B	19(A0)			; WAS IT LAST LETTER?
	BEQ.B	NOTLASTL
	MOVE.B	#1,LASTLETTER
NOTLASTL:
	LEA	ZCHARS+8*96*64,A4	; ZOOMSIZE FIXED CHAR
	LEA	PLANES+10240,A1		; PTR TO FIXER PLANE
	BSR.W	BLITCHAR 

	BRA.B	LETLOOP
NOTFIN:	SUB.B	#1,18(A0)		; SUB COUNTER
	
DONE:	SWAP	D0			; HANDLE ANIMATION
	SWAP	D1
	SUB.L	10(A0),D0
	SUB.L	14(A0),D1
	MOVEM.L	D0/D1,2(A0)

LETLOOP:ADD.L	#24,A0
	DBF	D7,NEXTLETTER

	TST.B	LASTLETTER
	BEQ.B	TXTOUT
	CLR.B	LASTLETTER
	ADDQ.L	#1,TEXTPTR
	MOVE.L	TEXTPTR(PC),A0
	CMP.B	#$FF,(A0)
	BNE.B	NOTEND	
	MOVE.L	#TEXT,TEXTPTR
NOTEND:	MOVE.W	#85,X
	MOVE.W	#40,Y
	CLR.B	TXTSTATUS
	MOVE.B	#1,CLEARSTATUS
	BSR.W	INIT_LETTERS
TXTOUT:	RTS

INITLETTER:
	TST.B	TXTSTATUS		; TEXTPAGE FINISHED? NO FURTHER INIT
	BNE.W	LETLOOP			;
	MOVE.B	#1,0(A0)		; PUT STATUS
INITL:	MOVE.L	TEXTPTR(PC),A1		; GET ACTUAL LETTER
	ADDQ.L	#1,TEXTPTR
	MOVE.B	(A1),D0			;
	TST.B	1(A1)			; NEXT LETTER = ZERO AND END??
	BNE.B	NOTLAST
	MOVE.B	#1,19(A0)		; SET LAST LETTER STATUS
NOTLAST:TST.B	D0			; PAGEENDE? LETZTER BUCHSTABE..
	BNE.B	NOTXTEND
	MOVE.B	#1,TXTSTATUS
	CLR.B	(A0)
	BRA.W	LETLOOP
NOTXTEND:
	CMP.B	#1,D0			; NEW LINE?
	BNE.B	NONEWL
	MOVE.W	#85,X
	ADD.W	#9,Y
	BRA.B	INITL
NONEWL:	MOVE.B	D0,1(A0)		; PUT LETTER

	MOVE.L	XSINEPTR(PC),A4
	MOVE.L	YSINEPTR(PC),A1
	MOVE.L	(A4),D0			; STARTX
	MOVE.L	(A1),D1			; STARTY
	ADD.L	#256,XSINEPTR
	ADD.L	#128,YSINEPTR
	CMP.L	#XSINE+1536,XSINEPTR
	BNE.B	NOXEND
	MOVE.L	#XSINE,XSINEPTR
NOXEND:	CMP.L	#YSINE+1536,YSINEPTR
	BNE.B	NOYEND
	MOVE.L	#YSINE,YSINEPTR
NOYEND:	MOVE.L	D0,D2
	MOVE.L	D1,D3
	SWAP	D0
	SWAP	D1
	MOVEM.L	D0/D1,2(A0)		; PUT X AND Y (SWAPPED)
	SUB.W	X(PC),D2		; GET X DELTA
	SUB.W	Y(PC),D3		; GET Y DELTA
	SWAP	D2
	SWAP	D3
	ASR.L	#7,D2			; /128
	ASR.L	#7,D3			; /128
	MOVEM.L	D2/D3,10(A0)		; PUT XDELTA/YDELTA
	ADDQ.W	#8,X	
	MOVE.B	#128,18(A0)		; PUT COUNTER
	CLR.L	20(A0)
	BRA.W	LETLOOP
	
; ==============================================================

; A1	= BITPLANE
; D0	= X.W
; D1	= Y.W
; D2.B	= CHAR IN ASCII
; D3.W	= SIZE (0-15)

BLITCHAR:
	ADDQ.L	#1,BLITTAB			; INC BLITNUM
	MOVEM.L	D0-D2,-(A7)
	SUB.B	#$20,D2
	EXT.W	D2
	LSL.L	#6,D2
	ADD.L	D2,A4

	LSL.W	#2,D1
	ADD.L	(A5,D1.W),A1

	MOVEQ	#0,D3
	MOVE.W	D0,D3
	MOVE.W	D0,D2
	LSR.W	#3,D0
	LEA	(A1,D0.W),A1
	LSR.W	#1,D0
	LSL.W	#4,D2
	SUB.W	D2,D3
	LSL.W	#8,D3	
	LSL.W	#4,D3	
	OR.W	#$0DFC,D3
	SWAP	D3
	MOVE.L	A4,(A3)+
	MOVE.L	A1,(A3)+
	MOVE.L	D3,(A3)+
	MOVEM.L	(A7)+,D0-D2
	RTS

; ===============================================================

DRAWLETTER:
	LEA	BLITTAB(PC),A5
	MOVE.L	(A5),D7
	MOVE.L	#0,(A5)+
WBLTT:	BTST	#14,$2(A6)
	BNE.B	WBLTT
	MOVE.L	#$FFFFFFFF,$44(A6)
	MOVE.W	#36,$62(A6)
	MOVE.W	#0,$64(A6)
	MOVE.W	#36,$66(A6)
NEXT:	BTST	#14,$2(A6)
	BNE.B	NEXT
	MOVE.L	(A5)+,$50(A6)
	MOVE.L	(A5),$54(A6)
	MOVE.L	(A5)+,$4C(A6)
	MOVE.L	(A5)+,$40(A6)
	MOVE.W	#15*64+2,$58(A6)	
	DBF	D7,NEXT
	RTS
	
; ==============================================================

PRECALC:
	MOVE.L	DIVSTABPTR(PC),A6
	MOVE.L	(A6),D1
	MOVE.L	ZCHARSPTR(PC),A6
	MOVE.L	PRELOOP(PC),D2		; SIZE
	SUBQ.W	#1,D2			; COZ OF DBF
	LEA	CHARS,A5
	LEA	PIXTAB(PC),A2
	MOVEQ	#16,D7
	SUB.W	D2,D7
	LSR.W	#1,D7
	LSL.W	#2,D7
	LEA	(A2,D7.W),A2
	LEA	(A6,D7.W),A6
	MOVEQ	#96-1,D7
CHARLP:	MOVE.L	A5,A0
	MOVE.L	D2,D5
	MOVE.L	A6,A1
	MOVEQ	#0,D3			; YSTEP
COPYL:	MOVE.L	D2,D6
	MOVE.L	A2,A3
	MOVEQ	#0,D0			; XSTEP
COPYC:	MOVEM.W	(A3)+,D4/A4
	BTST	D0,(A0)
	BEQ.B	NOSET
	BSET	D4,(A1,A4.W)
NOSET:	SWAP	D0
	ADD.L	D1,D0
	SWAP	D0
	DBF	D6,COPYC
	SWAP	D3
	ADD.L	D1,D3
	SWAP	D3
	LEA	(A5,D3.W),A0
	ADDQ.L	#4,A1
	DBF	D5,COPYL
	ADDQ.L	#8,A5
	ADD.L	#16*4,A6
	DBF	D7,CHARLP
	ADD.L	#96*16*4,ZCHARSPTR
	ADD.L	#4,DIVSTABPTR
	SUBQ.L	#1,PRELOOP
	BNE.W	PRECALC
	RTS
ZCHARSPTR:
	DC.L	ZCHARS	


** LineRoutine:
** a0	 plane
** a2	 dl_mulutab
** a6	 $dff002 (call dl_init before)
** d0/d1
** d2/d3 both points of the line
**
** Routine kills:
** a0/a1/d0-d5
**

dl_width = 40
dl_height = 256

dl_init:	
		moveq	#-1,d1
		moveq	#dl_width,d0
		moveq	#6,d2
.wb:		btst	d2,2(a6)
		bne.s	.wb
		move.w	d1,$44(a6)
		move.w	d1,$72(a6)
		move.w	#$8000,$74(a6)
		move.w	d0,$60(a6)
		move.w	d0,$66(a6)
		rts

dl_mulutab:	ds.w	dl_height
dl_init0:	lea	dl_mulutab(pc),a0
		moveq	#0,d0
		move.w	#dl_width,d1
		move.w	#dl_height-1,d2
.1:		move.w	d0,(a0)+
		add.w	d1,d0
		dbra	d2,.1
		rts

drawline:	cmp.w	d1,d3
		bge.s	.y1ly2
		exg	d0,d2
		exg	d1,d3
.y1ly2:		sub.w	d1,d3
		add.w	d1,d1
		add.w	(a2,d1.w),a0
		moveq	#0,d1
		sub.w	d0,d2
		bge.s	.xdpos
		addq.w	#2,d1
		neg.w	d2
.xdpos:		moveq	#$f,d4
		and.w	d0,d4
		move.b	d4,d5
		not.b	d5
		lsr.w	#3,d0
		add.w	d0,a0
		ror.w	#4,d4
		or.w	#$b4a,d4
		swap	d4
		cmp.w	d2,d3
		bge.s	.dygdx
		addq.w	#1,d1
		exg	d2,d3
.dygdx:		add.w	d2,d2
		move.w	d2,d0
		sub.w	d3,d0
		addx.w	d1,d1
		move.b	dl_oktants(pc,d1.w),d4
		swap	d2
		move.w	d0,d2
		sub.w	d3,d2
		moveq	#6,d1
		lsl.w	d1,d3
		add.w	#$42,d3
		lea	$52(a6),a1
.wb:		btst	d1,2(a6)
		bne.s	.wb
		bchg	d5,(a0)
		move.l	d4,$40(a6)
		move.l	d2,$62(a6)
		move.l	a0,$48(a6)
		move.w	d0,(a1)+
		move.l	a0,(a1)+
		move.w	d3,(a1)
		rts

dl_oktants:	dc.b	2+1,2+1+$40
		dc.b	2+17,2+17+$40
		dc.b	2+9,2+9+$40
		dc.b	2+21,2+21+$40


; ==============================================================

REPLAY:	INCBIN	"REPLAY.BIN"

; ==============================================================
CURPLANES:
	DC.L	PLANE1, PLANE2, PLANE3
CALCADD:DC.L	0
CLEARLINE:
	DC.L	51*40
CLEARDELAY:
	DC.W	13
CLEARSTATUS:
	DC.B	0,0
BLITTAB:
	BLK.L	138*3,0
SINUS:	INCBIN	"SINUS"
	INCBIN	"SINUS"

POINTS:	
	DC.W	400/16,	400/16
	DC.W	-400/16,400/16
	DC.W	-400/16,200/16
	DC.W	150/16,	200/16
	DC.W	150/16,	100/16
	DC.W	-200/16,100/16
	DC.W	-200/16,-100/16
	DC.W	150/16,	-100/16
	DC.W	150/16,	-400/16
	DC.W	400/16,	-400/16
	DC.W	400/16,	400/16


	DC.W	0,400/4
	DC.W	116/4,160/4
	DC.W	380/4,124/4		
	DC.W	192/4,-60/4
	DC.W	236/4,-324/4
	DC.W	0,-200/4
	DC.W	-236/4,-324/4
	DC.W	-192/4,-60/4
	DC.W	-380/4,124/4	
	DC.W	-116/4,160/4
	DC.W	0,400/4
CALCPOINTS:
	BLK.B	128*(CALCPOINTS-POINTS),0
DIVSTABPTR:
	DC.L	DIVSTAB
DIVSTAB:INCBIN	"DIVSTAB"
ZOOMTAB:
	BLK.L	18,ZCHARS+14*(96*64)
	BLK.L	18,ZCHARS+13*(96*64)
	BLK.L	18,ZCHARS+12*(96*64)
	BLK.L	18,ZCHARS+11*(96*64)
	BLK.L	18,ZCHARS+10*(96*64)
	BLK.L	18,ZCHARS+9*(96*64)
	BLK.L	17,ZCHARS+8*(96*64)
	BLK.L	13,ZCHARS+0*(96*64)
LASTLETTER:
	DC.B	0,0
XSINEPTR:
	DC.L	XSINE
YSINEPTR:
	DC.L	YSINE+256
XSINE:	INCBIN	"XSINE"
YSINE:	INCBIN	"YSINE"

TXTSTATUS:
	DC.B	0,0

X:	DC.W	85
Y:	DC.W	40
TEXTPTR:DC.L	TEXT
TEXT:	
	DC.B	"         DA MIGHTY",1
	DC.B	1
	DC.B	"    = F L A S H T R O =",1
	DC.B	1
	DC.B	"PRESENTS ANOTHER HOT CRACK",1
	DC.B	"  FOR YOUR GROWING RETRO",1
	DC.B	"       COLLECTION !!!",1
	DC.B	1
	DC.B	" * LEMMINGS (C) PSYGNOSIS *",1
	DC.B	" --------------------------",1
	DC.B	1
	DC.B	" MFM, COPYLOCK + CHECKSUMS",1
	DC.B	"        CRACKED BY:",1
	DC.B	1
	DC.B	"  ALPHA ONE AND MUSASHI9!",1
	DC.B	"                         ",1
	DC.B	"                         ",0	; DELAY

	DC.B	1
	DC.B	1
	DC.B	"--------------------------",1
	DC.B	1
	DC.B	"  SOME GREETINGS MUST GO",1
	DC.B	" USUAL FLASHTRO VISITORS:",1
	DC.B	1
	DC.B	"   SIRIAX - PMC - XYXXY",1
	DC.B	"BLACKHAWK - STINGRAY - STU",1
	DC.B	"     WAYNEK - MR.SPIV",1
	DC.B	1
	DC.B    " ... AND TO THE RETROGURU",1
	DC.B	" TEAM FOR STILL PRODUCING",1
	DC.B	"      AMIGA GAMES !!!",1
	DC.B	1
	DC.B	"--------------------------",1
	DC.B	"                         ",1
	DC.B	"                         ",0	; DELAY

	DC.B	1
	DC.B	1
	DC.B	1
	DC.B	"CODE  : ALPHA ONE",1
	DC.B	"GFX   : MUSASHI9",1
	DC.B	"MUSIC : ESTRAYK",1
	DC.B	1
	DC.B	1
	DC.B	1
	DC.B	1
	DC.B	"            CLICK TO EXIT",1
	DC.B	"              SEE YA L8R!",1
	DC.B	"        -----------------",1
	DC.B	"        (C) 2013 FLASHTRO",1
	DC.B	"                         ",0	; DELAY


	DC.B	$FF,$FF
	EVEN

LETTER:	DC.B	1		; STATUS: 0=NEEDS TO BE INITIALIZED
	DC.B	"A"		; CHAR IN ASCII
	DC.L	0,0		; CURRENT X/Y.W
	DC.L	0,0		; XSTEPS / YSTEPS
	DC.B	0,0		; COUNTER, LASTLETTERSTATUS
	DC.L	0		; ADDER FOR ZOOMTAB

LETTERS:BLK.B	LETTERCOUNT*24,0

PRELOOP:DC.L	16

PIXTAB:	DC.W	0,1
	DC.W	1,1
	DC.W	2,1
	DC.W	3,1
	DC.W	4,1
	DC.W	5,1
	DC.W	6,1
	DC.W	7,1
	DC.W	0,0
	DC.W	1,0
	DC.W	2,0
	DC.W	3,0
	DC.W	4,0
	DC.W	5,0
	DC.W	6,0
	DC.W	7,0

MULUTAB:BLK.L	512,0
	
COP:	DC.W	$01FC,$0000,$0106,$0000
	DC.W	$008E,$2C81,$0090,$2CC1,$0092,$0038,$0094,$00D0
	DC.W	$0102,$0000,$0104,$0000,$0108,$0000,$010A,$0000
	DC.W	$0120,$0000,$0122,$0000,$0124,$0000,$0126,$0000
	DC.W	$0128,$0000,$012a,$0000,$012c,$0000,$012e,$0000
	DC.W	$0130,$0000,$0132,$0000,$0134,$0000,$0136,$0000
	DC.W	$0138,$0000,$013a,$0000,$013c,$0000,$013e,$0000
	DC.W	$0100,$5200
PL:	DC.W	$00E0,$0000,$00E2,$0000
	DC.W	$00E4,$0000,$00E6,$0000
	DC.W	$00E8,$0000,$00EA,$0000
	DC.W	$00EC,$0000,$00EE,$0000
	DC.W	$00F0,$0000,$00F2,$0000
	INCBIN	"FLASHTRO.COLS"
COPCL:	BLK.W	211*24,0
	DC.W	$FFDF,$FFFE
COPCL2:	BLK.W	32*24,0	
	DC.L	-2

PLANE1:	BLK.B	2*10240,0
PLANE2:	BLK.B	2*10240,0
PLANE3:	BLK.B	2*10240,0
PLANES:	BLK.B	5*10240,0
LOGO:	INCBIN	"FLASHTRO.RAW"
CHARS:	INCBIN	"FONTS/REBELS.FNT"
ZCHARS:	BLK.L	16*(96*16),0
MOD:	INCBIN	"SOUNDS/P61.BACK"

; ==============================================================
